/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.transformers;

import java.util.HashMap;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.TransformerException;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.transport.http.transformers.HttpRequestBodyToParamMap;

@RunWith(value=MockitoJUnitRunner.class)
@SmallTest
public class HttpRequestBodyToParamMapTestCase
extends AbstractMuleTestCase {
    @Mock
    private MuleContext muleContext;

    @Test
    public void validGet() throws TransformerException {
        MuleMessage msg = this.createMessage("GET", "text/plain");
        this.verifyTransformation(this.transform(msg));
    }

    @Test
    public void validPost() throws TransformerException {
        MuleMessage msg = this.createMessage("POST", "application/x-www-form-urlencoded");
        this.verifyTransformation(this.transform(msg));
    }

    @Test
    public void validPut() throws TransformerException {
        MuleMessage msg = this.createMessage("PUT", "application/x-www-form-urlencoded");
        this.verifyTransformation(this.transform(msg));
    }

    @Test(expected=TransformerException.class)
    public void invalidContentType() throws TransformerException {
        MuleMessage msg = this.createMessage("POST", "application/json");
        this.transform(msg);
    }

    private Object transform(MuleMessage msg) throws TransformerException {
        HttpRequestBodyToParamMap transformer = new HttpRequestBodyToParamMap();
        return transformer.transformMessage(msg, "UTF-8");
    }

    private void verifyTransformation(Object payload) throws TransformerException {
        Assert.assertThat((Object)(payload instanceof Map), (Matcher)CoreMatchers.is((Object)true));
        Map map = (Map)payload;
        Assert.assertThat((Object)map.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat(map.get("key1"), (Matcher)CoreMatchers.is((Object)"value1"));
        Assert.assertThat(map.get("key2"), (Matcher)CoreMatchers.is((Object)"value2"));
    }

    private MuleMessage createMessage(String method, String contentType) {
        HashMap<String, String> inboundProperties = new HashMap<String, String>();
        inboundProperties.put("http.method", method);
        inboundProperties.put("Content-Type", contentType);
        String payload = "key1=value1&key2=value2";
        if ("GET".equals(method)) {
            payload = "http://localhost/?" + payload;
        }
        DefaultMuleMessage msg = new DefaultMuleMessage(payload, inboundProperties, null, null, this.muleContext){

            public String getPayloadAsString(String encoding) throws Exception {
                return super.getPayload().toString();
            }

            public byte[] getPayloadAsBytes() throws Exception {
                return ((String)super.getPayload()).getBytes();
            }
        };
        return msg;
    }
}

