/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.transformers;

import java.io.Serializable;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.lang.SerializationUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMessageCollection;
import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.MuleMessageCollection;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.transport.NullPayload;
import org.mule.transport.http.HttpRequest;
import org.mule.transport.http.RequestLine;
import org.mule.transport.http.transformers.ObjectToHttpClientMethodRequest;

public class ObjectToHttpClientMethodRequestTestCase
extends AbstractMuleContextTestCase {
    private InboundEndpoint endpoint;

    private MuleMessage setupRequestContext(String url, String method) throws Exception {
        HttpRequest request = new HttpRequest(new RequestLine(method, url, HttpVersion.HTTP_1_1), null, "UTF-8");
        this.endpoint = muleContext.getEndpointFactory().getInboundEndpoint(url);
        MuleEvent event = ObjectToHttpClientMethodRequestTestCase.getTestEvent((Object)request, (InboundEndpoint)this.endpoint);
        MuleMessage message = event.getMessage();
        message.setOutboundProperty("http.method", (Object)method);
        message.setOutboundProperty("MULE_ENDPOINT", (Object)url);
        RequestContext.setEvent((MuleEvent)event);
        return message;
    }

    private MuleMessageCollection setupRequestContextForCollection(String url, String method) throws Exception {
        HttpRequest request = new HttpRequest(new RequestLine(method, url, HttpVersion.HTTP_1_1), null, "UTF-8");
        this.endpoint = muleContext.getEndpointFactory().getInboundEndpoint(url);
        MuleEvent event = ObjectToHttpClientMethodRequestTestCase.getTestEvent((Object)request, (InboundEndpoint)this.endpoint);
        DefaultMessageCollection message = new DefaultMessageCollection(muleContext);
        message.setOutboundProperty("http.method", (Object)method);
        message.setOutboundProperty("MULE_ENDPOINT", (Object)url);
        RequestContext.setEvent((MuleEvent)event);
        return message;
    }

    private ObjectToHttpClientMethodRequest createTransformer() throws Exception {
        ObjectToHttpClientMethodRequest transformer = new ObjectToHttpClientMethodRequest();
        transformer.setMuleContext(muleContext);
        transformer.setEndpoint((ImmutableEndpoint)this.endpoint);
        transformer.initialise();
        return transformer;
    }

    protected void doTearDown() throws Exception {
        RequestContext.setEvent(null);
    }

    @Test
    public void testUrlWithoutQuery() throws Exception {
        MuleMessage message = this.setupRequestContext("http://localhost:8080/services", "GET");
        message.setPayload((Object)NullPayload.getInstance());
        ObjectToHttpClientMethodRequest transformer = this.createTransformer();
        Object response = transformer.transform((Object)message);
        Assert.assertTrue((boolean)(response instanceof HttpMethod));
        HttpMethod httpMethod = (HttpMethod)response;
        Assert.assertEquals(null, (Object)httpMethod.getQueryString());
    }

    @Test
    public void testUrlWithQuery() throws Exception {
        MuleMessage message = this.setupRequestContext("http://localhost:8080/services?method=echo", "GET");
        message.setPayload((Object)NullPayload.getInstance());
        ObjectToHttpClientMethodRequest transformer = this.createTransformer();
        Object response = transformer.transform((Object)message);
        Assert.assertTrue((boolean)(response instanceof HttpMethod));
        HttpMethod httpMethod = (HttpMethod)response;
        Assert.assertEquals((Object)"method=echo", (Object)httpMethod.getQueryString());
    }

    @Test
    public void testUrlWithUnescapedQuery() throws Exception {
        MuleMessage message = this.setupRequestContext("http://mycompany.com/test?fruits=apple%20orange", "GET");
        message.setPayload((Object)NullPayload.getInstance());
        ObjectToHttpClientMethodRequest transformer = this.createTransformer();
        Object response = transformer.transform((Object)message);
        Assert.assertTrue((boolean)(response instanceof HttpMethod));
        HttpMethod httpMethod = (HttpMethod)response;
        Assert.assertEquals((Object)"fruits=apple%20orange", (Object)httpMethod.getQueryString());
    }

    @Test
    public void testAppendedUrl() throws Exception {
        MuleMessage message = this.setupRequestContext("http://mycompany.com/test?fruits=apple%20orange", "GET");
        message.setPayload((Object)"test");
        message.setOutboundProperty("http.get.body.param", (Object)"body");
        ObjectToHttpClientMethodRequest transformer = this.createTransformer();
        Object response = transformer.transform((Object)message);
        Assert.assertTrue((boolean)(response instanceof HttpMethod));
        HttpMethod httpMethod = (HttpMethod)response;
        Assert.assertEquals((Object)"fruits=apple%20orange&body=test", (Object)httpMethod.getQueryString());
    }

    @Test
    public void testEncodingOfParamValueTriggeredByMessageProperty() throws Exception {
        String encodedPayload = "encoded%20payload";
        MuleMessage message = this.setupRequestContext("http://mycompany.com/", "GET");
        message.setOutboundProperty("http.encode.paramvalue", (Object)false);
        message.setOutboundProperty("http.get.body.param", (Object)"body");
        message.setPayload((Object)encodedPayload);
        ObjectToHttpClientMethodRequest transformer = this.createTransformer();
        Object result = transformer.transform((Object)message);
        Assert.assertTrue((boolean)(result instanceof GetMethod));
        String expected = "body=" + encodedPayload;
        Assert.assertEquals((Object)expected, (Object)((GetMethod)result).getQueryString());
    }

    public void testPostMethod() throws Exception {
        MuleMessage message = this.setupRequestContext("http://localhost:8080/services", "POST");
        String contentType = "text/plain";
        message.setPayload((Object)"I'm a payload");
        message.setInvocationProperty("Content-Type", (Object)"text/plain");
        ObjectToHttpClientMethodRequest transformer = this.createTransformer();
        Object response = transformer.transform((Object)message);
        Assert.assertTrue((boolean)(response instanceof PostMethod));
        HttpMethod httpMethod = (HttpMethod)response;
        Assert.assertEquals(null, (Object)httpMethod.getQueryString());
        Assert.assertEquals((Object)"text/plain", (Object)httpMethod.getRequestHeader("Content-Type").getValue());
    }

    public void testPutMethod() throws Exception {
        MuleMessage message = this.setupRequestContext("http://localhost:8080/services", "PUT");
        String contentType = "text/plain";
        message.setPayload((Object)"I'm a payload");
        message.setInvocationProperty("Content-Type", (Object)"text/plain");
        ObjectToHttpClientMethodRequest transformer = this.createTransformer();
        Object response = transformer.transform((Object)message);
        Assert.assertTrue((boolean)(response instanceof PutMethod));
        HttpMethod httpMethod = (HttpMethod)response;
        Assert.assertEquals(null, (Object)httpMethod.getQueryString());
        Assert.assertEquals((Object)"text/plain", (Object)httpMethod.getRequestHeader("Content-Type").getValue());
    }

    @Test
    public void testPostMethodWithHttp10ForMuleMessage() throws Exception {
        MuleMessage message = this.setupRequestContext("http://localhost:8080/services", "POST");
        String contentType = "text/plain";
        String payload = "I'm a payload";
        message.setPayload((Object)payload);
        message.setInvocationProperty("Content-Type", (Object)"text/plain");
        message.setOutboundProperty("http.version", (Object)"HTTP/1.0");
        ObjectToHttpClientMethodRequest transformer = this.createTransformer();
        Object response = transformer.transform((Object)message);
        Assert.assertTrue((boolean)(response instanceof PostMethod));
        HttpMethod httpMethod = (HttpMethod)response;
        Assert.assertEquals(null, (Object)httpMethod.getQueryString());
        byte[] byteArrayContent = ((ByteArrayRequestEntity)((PostMethod)httpMethod).getRequestEntity()).getContent();
        Assert.assertArrayEquals((byte[])payload.getBytes(), (byte[])byteArrayContent);
    }

    @Test
    public void testPostMethodWithHttp10ForMuleMessageCollection() throws Exception {
        MuleMessageCollection message = this.setupRequestContextForCollection("http://localhost:8080/services", "POST");
        MuleMessage messageOne = this.setupRequestContext("http://localhost:8080/services", "POST");
        message.addMessage(messageOne);
        String contentType = "text/plain";
        String payload = "I'm a payload";
        messageOne.setPayload((Object)payload);
        message.setInvocationProperty("Content-Type", (Object)"text/plain");
        message.setOutboundProperty("http.version", (Object)"HTTP/1.0");
        ObjectToHttpClientMethodRequest transformer = this.createTransformer();
        Object response = transformer.transform((Object)message);
        Assert.assertTrue((boolean)(response instanceof PostMethod));
        HttpMethod httpMethod = (HttpMethod)response;
        Assert.assertEquals(null, (Object)httpMethod.getQueryString());
        byte[] byteArrayContent = ((ByteArrayRequestEntity)((PostMethod)httpMethod).getRequestEntity()).getContent();
        byte[] expectedByteArrayContent = SerializationUtils.serialize((Serializable)((Serializable)message.getPayload()));
        Assert.assertArrayEquals((byte[])expectedByteArrayContent, (byte[])byteArrayContent);
    }
}

