/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import java.net.URI;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.transport.http.HttpClientMessageDispatcher;
import org.mule.transport.http.HttpsConnector;
import org.mule.transport.http.MuleHostConfiguration;
import org.mule.transport.http.MuleSecureProtocolSocketFactory;

public class HttpsClientMessageDispatcher
extends HttpClientMessageDispatcher {
    private final Map<String, Protocol> PROTOCOL = Collections.synchronizedMap(new HashMap());

    public HttpsClientMessageDispatcher(OutboundEndpoint endpoint) {
        super(endpoint);
    }

    @Override
    protected HostConfiguration getHostConfig(URI uri) throws Exception {
        MuleHostConfiguration hostConfig = new MuleHostConfiguration(super.getHostConfig(uri));
        String host = uri.getHost();
        int port = uri.getPort();
        Protocol protocol = this.getProtocol(uri.getScheme().toLowerCase());
        hostConfig.setHost(host, port, protocol);
        return hostConfig;
    }

    private Protocol getProtocol(String scheme) throws GeneralSecurityException {
        Protocol protocol = this.PROTOCOL.get(scheme);
        if (protocol == null) {
            HttpsConnector httpsConnector = (HttpsConnector)this.httpConnector;
            SSLSocketFactory factory = httpsConnector.getSslSocketFactory();
            MuleSecureProtocolSocketFactory protocolSocketFactory = new MuleSecureProtocolSocketFactory(factory);
            protocol = new Protocol(scheme, (ProtocolSocketFactory)protocolSocketFactory, 443);
            this.PROTOCOL.put(scheme, protocol);
        }
        return protocol;
    }
}

