/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.service.Service;
import org.mule.api.transport.Connector;
import org.mule.api.transport.MessageReceiver;
import org.mule.api.transport.NoReceiverForEndpointException;
import org.mule.tck.testmodels.fruit.Orange;
import org.mule.transport.AbstractConnectorTestCase;
import org.mule.transport.http.HttpConnector;
import org.mule.transport.http.HttpMessageReceiver;
import org.mule.transport.http.HttpRequest;
import org.mule.transport.http.RequestLine;

@RunWith(value=MockitoJUnitRunner.class)
public class HttpConnectorTestCase
extends AbstractConnectorTestCase {
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private HttpMessageReceiver mockServiceOrderReceiverPort5555;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private HttpMessageReceiver mockServiceReceiverPort5555;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private HttpMessageReceiver mockServiceOrderReceiverPort7777;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private HttpMessageReceiver mockServiceReceiverPort7777;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private HttpMessageReceiver mockServiceReceiverAnotherHost;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private HttpMessageReceiver mockReceiverPort5555;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private HttpRequest mockHttpRequest;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private Socket mockSocket;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private RequestLine mockRequestLine;

    public Connector createConnector() throws Exception {
        HttpConnector c = new HttpConnector(muleContext);
        c.setName("HttpConnector");
        return c;
    }

    public String getTestEndpointURI() {
        return "http://localhost:60127";
    }

    public Object getValidMessage() throws Exception {
        return "Hello".getBytes();
    }

    @Test
    public void testValidListener() throws Exception {
        Service service = HttpConnectorTestCase.getTestService((String)"orange", Orange.class);
        InboundEndpoint endpoint = muleContext.getEndpointFactory().getInboundEndpoint(this.getTestEndpointURI());
        this.getConnector().registerListener(endpoint, (MessageProcessor)this.getSensingNullMessageProcessor(), (FlowConstruct)service);
    }

    @Test
    public void testProperties() throws Exception {
        HttpConnector c = (HttpConnector)this.getConnector();
        c.setSendBufferSize(1024);
        Assert.assertEquals((long)1024L, (long)c.getSendBufferSize());
        c.setSendBufferSize(0);
        Assert.assertEquals((long)-1L, (long)c.getSendBufferSize());
        int maxDispatchers = c.getMaxTotalDispatchers();
        HttpConnectionManagerParams params = c.getClientConnectionManager().getParams();
        Assert.assertEquals((long)maxDispatchers, (long)params.getDefaultMaxConnectionsPerHost());
        Assert.assertEquals((long)maxDispatchers, (long)params.getMaxTotalConnections());
    }

    @Test
    public void findReceiverByStem() throws Exception {
        Map<Object, MessageReceiver> receiversMap = this.createTestReceivers();
        Assert.assertThat((Object)((HttpMessageReceiver)HttpConnector.findReceiverByStem(receiversMap, (String)"http://somehost:5555/")), (Matcher)Is.is((Object)this.mockReceiverPort5555));
        Assert.assertThat((Object)((HttpMessageReceiver)HttpConnector.findReceiverByStem(receiversMap, (String)"http://somehost:5555/service")), (Matcher)Is.is((Object)this.mockServiceReceiverPort5555));
        Assert.assertThat((Object)((HttpMessageReceiver)HttpConnector.findReceiverByStem(receiversMap, (String)"http://somehost:5555/service/order")), (Matcher)Is.is((Object)this.mockServiceOrderReceiverPort5555));
        Assert.assertThat((Object)((HttpMessageReceiver)HttpConnector.findReceiverByStem(receiversMap, (String)"http://somehost:7777/service/order")), (Matcher)Is.is((Object)this.mockServiceOrderReceiverPort7777));
        Assert.assertThat((Object)((HttpMessageReceiver)HttpConnector.findReceiverByStem(receiversMap, (String)"http://somehost:7777/service")), (Matcher)Is.is((Object)this.mockServiceReceiverPort7777));
        Assert.assertThat((Object)((HttpMessageReceiver)HttpConnector.findReceiverByStem(receiversMap, (String)"http://anotherhost:5555/")), (Matcher)Is.is((Object)this.mockServiceReceiverAnotherHost));
    }

    private Map<Object, MessageReceiver> createTestReceivers() {
        HashMap<Object, MessageReceiver> receiversMap = new HashMap<Object, MessageReceiver>();
        receiversMap.put("http://somehost:5555/service/order", (MessageReceiver)this.mockServiceOrderReceiverPort5555);
        receiversMap.put("http://somehost:5555/service", (MessageReceiver)this.mockServiceReceiverPort5555);
        receiversMap.put("http://somehost:5555/", (MessageReceiver)this.mockReceiverPort5555);
        receiversMap.put("http://somehost:7777/service/order", (MessageReceiver)this.mockServiceOrderReceiverPort7777);
        receiversMap.put("http://somehost:7777/service", (MessageReceiver)this.mockServiceReceiverPort7777);
        receiversMap.put("http://anotherhost:5555/", (MessageReceiver)this.mockServiceReceiverAnotherHost);
        return receiversMap;
    }

    @Test
    public void lookupReceiverThatDoesNotExistsInThatPort() throws Exception {
        this.testLookupReceiver("somehost", 8888, "/management", null);
    }

    @Test
    public void lookupReceiverThatDoesNotExistsInThatHost() throws Exception {
        this.testLookupReceiver("nonexistenthost", 5555, "/service", null);
    }

    @Test
    public void lookupReceiverThatContainsPath() throws Exception {
        Mockito.when((Object)this.mockServiceReceiverPort5555.getEndpointURI().getPort()).thenReturn((Object)5555);
        Mockito.when((Object)this.mockServiceReceiverPort5555.getEndpointURI().getHost()).thenReturn((Object)"somehost");
        this.testLookupReceiver("somehost", 5555, "/service/product", this.mockServiceReceiverPort5555);
    }

    @Test
    public void lookupReceiverThatExistsWithExactSamePath() throws Exception {
        Mockito.when((Object)this.mockServiceReceiverPort5555.getEndpointURI().getPort()).thenReturn((Object)5555);
        Mockito.when((Object)this.mockServiceReceiverPort5555.getEndpointURI().getHost()).thenReturn((Object)"somehost");
        this.testLookupReceiver("somehost", 5555, "/service/order?param1=value1", this.mockServiceOrderReceiverPort5555);
    }

    @Test
    public void lookupReceiverByRequestLineThatDoesNotExistsInThatPort() throws Exception {
        this.testLookupReceiverByRequestLine("somehost", 8888, "/management", null);
    }

    @Test
    public void lookupReceiverByRequestLineThatDoesNotExistsInThatHost() throws Exception {
        this.testLookupReceiverByRequestLine("nonexistenthost", 5555, "/service", null);
    }

    @Test
    public void lookupReceiverByRequestLineThatContainsPath() throws Exception {
        Mockito.when((Object)this.mockServiceReceiverPort5555.getEndpointURI().getPort()).thenReturn((Object)5555);
        Mockito.when((Object)this.mockServiceReceiverPort5555.getEndpointURI().getHost()).thenReturn((Object)"somehost");
        this.testLookupReceiverByRequestLine("somehost", 5555, "/service/product", this.mockServiceReceiverPort5555);
    }

    @Test
    public void lookupReceiverByRequestLineThatExistsWithExactSamePath() throws Exception {
        Mockito.when((Object)this.mockServiceReceiverPort5555.getEndpointURI().getPort()).thenReturn((Object)5555);
        Mockito.when((Object)this.mockServiceReceiverPort5555.getEndpointURI().getHost()).thenReturn((Object)"somehost");
        this.testLookupReceiverByRequestLine("somehost", 5555, "/service/order?param1=value1", this.mockServiceOrderReceiverPort5555);
    }

    private void testLookupReceiver(String host, int port, String path, HttpMessageReceiver expectedMessageReceiver) {
        HttpConnector httpConnector = (HttpConnector)this.getConnector();
        httpConnector.getReceivers().putAll(this.createTestReceivers());
        Mockito.when((Object)this.mockHttpRequest.getRequestLine()).thenReturn((Object)this.mockRequestLine);
        Mockito.when((Object)this.mockRequestLine.getUrlWithoutParams()).thenReturn((Object)path);
        Mockito.when((Object)this.mockSocket.getLocalSocketAddress()).thenReturn((Object)new InetSocketAddress(host, port));
        Assert.assertThat((Object)httpConnector.lookupReceiver(this.mockSocket, this.mockHttpRequest), (Matcher)Is.is((Object)expectedMessageReceiver));
    }

    private void testLookupReceiverByRequestLine(String host, int port, String path, HttpMessageReceiver expectedMessageReceiver) throws NoReceiverForEndpointException {
        HttpConnector httpConnector = (HttpConnector)this.getConnector();
        httpConnector.getReceivers().putAll(this.createTestReceivers());
        Mockito.when((Object)this.mockRequestLine.getUrlWithoutParams()).thenReturn((Object)path);
        Mockito.when((Object)this.mockSocket.getLocalSocketAddress()).thenReturn((Object)new InetSocketAddress(host, port));
        if (expectedMessageReceiver != null) {
            Assert.assertThat((Object)httpConnector.lookupReceiver(this.mockSocket, this.mockRequestLine), (Matcher)Is.is((Object)expectedMessageReceiver));
        } else {
            try {
                httpConnector.lookupReceiver(this.mockSocket, this.mockRequestLine);
                Assert.fail((String)"exception should be thrown");
            }
            catch (NoReceiverForEndpointException e) {
                // empty catch block
            }
        }
    }
}

