/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.commons.httpclient.Header;
import org.junit.Assert;
import org.junit.Test;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleMessage;
import org.mule.api.transport.MuleMessageFactory;
import org.mule.transport.AbstractMuleMessageFactoryTestCase;
import org.mule.transport.NullPayload;
import org.mule.transport.http.HttpMuleMessageFactory;
import org.mule.transport.http.HttpMultipartMuleMessageFactory;
import org.mule.transport.http.HttpRequest;
import org.mule.transport.http.RequestLine;

public class HttpMultipartMuleMessageFactoryTestCase
extends AbstractMuleMessageFactoryTestCase {
    private static final String REQUEST_LINE = "POST /services/Echo HTTP/1.1";
    private static final String MULTIPART_BOUNDARY = "----------------------------299df9f9431b";
    private static final Header[] HEADERS = new Header[]{new Header("Content-Type", "multipart/form-data; boundary=----------------------------299df9f9431b")};
    private static final String MULTIPART_MESSAGE = "------------------------------299df9f9431b\r\nContent-Disposition: form-data; name=\"payload\"; filename=\"payload\"\r\nContent-Type: application/octet-stream\r\n\r\npart payload\r\n\r\n------------------------------299df9f9431b\r\nContent-Disposition: form-data; name=\"two\"; filename=\"two\"\r\nContent-Type: application/octet-stream\r\n\r\npart two\r\n\r\n------------------------------299df9f9431b--\r\n\r\n";
    private static final String MULTIPART_MESSAGE_NO_PAYLOAD = "------------------------------299df9f9431b\r\nContent-Disposition: form-data; name=\"nopayload\"; filename=\"nopayload\"\r\nContent-Type: application/octet-stream\r\n\r\npart nopayload\r\n\r\n------------------------------299df9f9431b\r\nContent-Disposition: form-data; name=\"dos\"; filename=\"dos\"\r\nContent-Type: application/octet-stream\r\n\r\npart dos\r\n\r\n------------------------------299df9f9431b--\r\n\r\n";

    protected MuleMessageFactory doCreateMuleMessageFactory() {
        return new HttpMultipartMuleMessageFactory();
    }

    protected Object getValidTransportMessage() throws Exception {
        RequestLine requestLine = RequestLine.parseLine((String)REQUEST_LINE);
        HttpRequest request = new HttpRequest(requestLine, HEADERS, null, this.encoding);
        return request;
    }

    protected Object getUnsupportedTransportMessage() {
        return "this is not a valid transport message for HttpMuleMessageFactory";
    }

    @Test
    public void testValidPayload() throws Exception {
        HttpMuleMessageFactory factory = (HttpMuleMessageFactory)this.createMuleMessageFactory();
        factory.setExchangePattern(MessageExchangePattern.ONE_WAY);
        HttpRequest request = this.createMultiPartHttpRequest(MULTIPART_MESSAGE);
        MuleMessage message = factory.create((Object)request, this.encoding, muleContext);
        Assert.assertNotNull((Object)message);
        Assert.assertTrue((boolean)(message.getPayload() instanceof InputStream));
    }

    @Test
    public void testValidPayloadWihtNoPayloadPart() throws Exception {
        HttpMuleMessageFactory factory = (HttpMuleMessageFactory)this.createMuleMessageFactory();
        factory.setExchangePattern(MessageExchangePattern.ONE_WAY);
        HttpRequest request = this.createMultiPartHttpRequest(MULTIPART_MESSAGE_NO_PAYLOAD);
        MuleMessage message = factory.create((Object)request, this.encoding, muleContext);
        Assert.assertNotNull((Object)message);
        Assert.assertTrue((boolean)(message.getPayload() instanceof NullPayload));
    }

    private HttpRequest createMultiPartHttpRequest(String message) throws Exception {
        RequestLine requestLine = RequestLine.parseLine((String)REQUEST_LINE);
        ByteArrayInputStream stream = new ByteArrayInputStream(message.getBytes());
        return new HttpRequest(requestLine, HEADERS, (InputStream)stream, this.encoding);
    }
}

