/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.components;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.transport.http.CacheControlHeader;
import org.mule.transport.http.CookieWrapper;
import org.mule.transport.http.HttpResponse;
import org.mule.transport.http.components.HttpResponseBuilder;

@SmallTest
public class HttpResponseBuilderTestCase
extends AbstractMuleTestCase {
    private static final String HTTP_BODY = "<html><head></head><body><p>This is the response body</p></body></html>";
    private static final String HEADER_STATUS = "#[header:status]";
    private static final String HEADER_CONTENT_TYPE = "#[header:contentType]";
    private static final String HEADER_CACHE_CONTROL = "#[header:cacheControl]";
    private static final String HEADER_EXPIRES = "#[header:expires]";
    private static final String HEADER_LOCATION = "#[header:location]";
    private static final String HEADER_NAME = "#[header:name]";
    private static final String HEADER_VALUE = "#[header:value]";
    private static final String HEADER_DOMAIN = "#[header:domain]";
    private static final String HEADER_PATH = "#[header:path]";
    private static final String HEADER_EXPIRY_DATE = "#[header:expiryDate]";
    private static final String HEADER_SECURE = "#[header:secure]";
    private static final String HEADER_VERSION = "#[header:version]";
    private static final String HEADER_DIRECTIVE = "#[header:directive]";
    private static final String HEADER_MAX_AGE = "#[header:maxAge]";
    private static final String HEADER_MUST_REVALIDATE = "#[header:mustRevalidate]";
    private static final String HEADER_NO_CACHE = "#[header:noCache]";
    private static final String HEADER_NO_STORE = "#[header:noStore]";
    private MuleContext muleContext;
    private MuleMessage mockMuleMessage;
    private ExpressionManager mockExpressionManager = (ExpressionManager)Mockito.mock(ExpressionManager.class);
    private MuleEvent mockEvent;

    @Before
    public void setUp() {
        this.muleContext = (MuleContext)Mockito.mock(MuleContext.class);
        this.mockEvent = (MuleEvent)Mockito.mock(MuleEvent.class);
        this.mockMuleMessage = (MuleMessage)Mockito.mock(MuleMessage.class);
        this.mockExpressionManager = (ExpressionManager)Mockito.mock(ExpressionManager.class);
        Mockito.when((Object)this.muleContext.getExpressionManager()).thenReturn((Object)this.mockExpressionManager);
    }

    @Test
    public void testEmptyHttpResponseBuilder() throws Exception {
        HttpResponseBuilder httpResponseBuilder = this.createHttpResponseBuilder();
        DefaultMuleMessage muleMessage = new DefaultMuleMessage((Object)HTTP_BODY, this.muleContext);
        Mockito.when((Object)this.mockEvent.getMessage()).thenReturn((Object)muleMessage);
        this.mockParse();
        HttpResponse httpResponse = (HttpResponse)httpResponseBuilder.process(this.mockEvent).getMessage().getPayload();
        Assert.assertEquals((Object)HTTP_BODY, (Object)httpResponse.getBodyAsString());
        Assert.assertEquals((Object)"HTTP/1.1", (Object)httpResponse.getHttpVersion().toString());
        Assert.assertEquals((long)200L, (long)httpResponse.getStatusCode());
        this.validateHeader(httpResponse.getHeaders(), "Content-Type", "text/plain");
    }

    @Test
    public void testHttpResponseBuilderAttributes() throws Exception {
        HttpResponseBuilder httpResponseBuilder = this.createHttpResponseBuilder();
        DefaultMuleMessage muleMessage = new DefaultMuleMessage((Object)HTTP_BODY, this.muleContext);
        Mockito.when((Object)this.mockEvent.getMessage()).thenReturn((Object)muleMessage);
        httpResponseBuilder.setContentType("text/html");
        httpResponseBuilder.setStatus(String.valueOf(500));
        this.mockParse();
        HttpResponse httpResponse = (HttpResponse)httpResponseBuilder.process(this.mockEvent).getMessage().getPayload();
        Assert.assertEquals((Object)HTTP_BODY, (Object)httpResponse.getBodyAsString());
        Assert.assertEquals((Object)"HTTP/1.1", (Object)httpResponse.getHttpVersion().toString());
        Assert.assertEquals((long)500L, (long)httpResponse.getStatusCode());
        this.validateHeader(httpResponse.getHeaders(), "Content-Type", "text/html");
    }

    @Test
    public void testHttpResponseBuilderAttributesWithExpressions() throws Exception {
        HttpResponseBuilder httpResponseBuilder = this.createHttpResponseBuilder();
        DefaultMuleMessage muleMessage = new DefaultMuleMessage((Object)HTTP_BODY, this.muleContext);
        Mockito.when((Object)this.mockEvent.getMessage()).thenReturn((Object)muleMessage);
        httpResponseBuilder.setStatus(HEADER_STATUS);
        httpResponseBuilder.setContentType(HEADER_CONTENT_TYPE);
        Mockito.when((Object)this.mockExpressionManager.parse(HEADER_STATUS, (MuleMessage)muleMessage)).thenReturn((Object)String.valueOf(500));
        Mockito.when((Object)this.mockExpressionManager.parse(HEADER_CONTENT_TYPE, (MuleMessage)muleMessage)).thenReturn((Object)"text/html");
        HttpResponse httpResponse = (HttpResponse)httpResponseBuilder.process(this.mockEvent).getMessage().getPayload();
        Assert.assertEquals((Object)HTTP_BODY, (Object)httpResponse.getBodyAsString());
        Assert.assertEquals((Object)"HTTP/1.1", (Object)httpResponse.getHttpVersion().toString());
        Assert.assertEquals((long)500L, (long)httpResponse.getStatusCode());
        this.validateHeader(httpResponse.getHeaders(), "Content-Type", "text/html");
    }

    @Test
    public void testHttpResponseBuilderHeadersWithExpressions() throws Exception {
        HttpResponseBuilder httpResponseBuilder = this.createHttpResponseBuilder();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Cache-Control", HEADER_CACHE_CONTROL);
        headers.put("Expires", HEADER_EXPIRES);
        headers.put("Location", HEADER_LOCATION);
        httpResponseBuilder.setHeaders(headers);
        Mockito.when((Object)this.mockExpressionManager.parse("Cache-Control", this.mockMuleMessage)).thenReturn((Object)"Cache-Control");
        Mockito.when((Object)this.mockExpressionManager.parse("Expires", this.mockMuleMessage)).thenReturn((Object)"Expires");
        Mockito.when((Object)this.mockExpressionManager.parse("Location", this.mockMuleMessage)).thenReturn((Object)"Location");
        Mockito.when((Object)this.mockExpressionManager.parse(HEADER_CACHE_CONTROL, this.mockMuleMessage)).thenReturn((Object)"max-age=3600");
        Mockito.when((Object)this.mockExpressionManager.isExpression(HEADER_EXPIRES)).thenReturn((Object)true);
        Mockito.when((Object)this.mockExpressionManager.evaluate(HEADER_EXPIRES, this.mockMuleMessage)).thenReturn((Object)"Thu, 01 Dec 1994 16:00:00 GMT");
        Mockito.when((Object)this.mockExpressionManager.parse(HEADER_LOCATION, this.mockMuleMessage)).thenReturn((Object)"http://localhost:8080");
        HttpResponse response = new HttpResponse();
        httpResponseBuilder.setHeaders(response, this.mockMuleMessage);
        this.validateHeaders(response.getHeaders());
    }

    @Test
    public void testHttpResponseBuilderHeaders() throws Exception {
        HttpResponseBuilder httpResponseBuilder = this.createHttpResponseBuilder();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Cache-Control", "max-age=3600");
        headers.put("Expires", "Thu, 01 Dec 1994 16:00:00 GMT");
        headers.put("Location", "http://localhost:8080");
        httpResponseBuilder.setHeaders(headers);
        this.mockParse();
        HttpResponse response = new HttpResponse();
        httpResponseBuilder.setHeaders(response, this.mockMuleMessage);
        this.validateHeaders(response.getHeaders());
    }

    @Test
    public void testHttpResponseBuilderHeadersWithExpressionInHeaderName() throws Exception {
        HttpResponseBuilder httpResponseBuilder = this.createHttpResponseBuilder();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(HEADER_LOCATION, "http://localhost:9090");
        httpResponseBuilder.setHeaders(headers);
        Mockito.when((Object)this.mockExpressionManager.parse(HEADER_LOCATION, this.mockMuleMessage)).thenReturn((Object)"Location");
        Mockito.when((Object)this.mockExpressionManager.parse("http://localhost:9090", this.mockMuleMessage)).thenReturn((Object)"http://localhost:9090");
        HttpResponse response = new HttpResponse();
        httpResponseBuilder.setHeaders(response, this.mockMuleMessage);
        this.validateHeader(response.getHeaders(), "Location", "http://localhost:9090");
    }

    @Test
    public void testHttpResponseBuilderCookies() throws Exception {
        HttpResponseBuilder httpResponseBuilder = this.createHttpResponseBuilder();
        ArrayList<CookieWrapper> cookies = new ArrayList<CookieWrapper>();
        cookies.add(this.createCookie("userName", "John_Galt", "localhost", "/", "Thu, 15 Dec 2013 16:00:00 GMT", "true", "1"));
        cookies.add(this.createCookie("userId", "1", "localhost", "/", "Thu, 01 Dec 2013 16:00:00 GMT", "true", "1"));
        this.mockParse();
        httpResponseBuilder.setCookies(cookies);
        HttpResponse response = new HttpResponse();
        httpResponseBuilder.setCookies(response, this.mockMuleMessage);
        Map<String, String> responseCookies = this.getHeaderCookie(response.getHeaders());
        Assert.assertNotNull(responseCookies);
        Assert.assertEquals((Object)"userName=John_Galt; Version=1; Domain=localhost; Path=/; Secure; Expires=Sun, 15-Dec-2013 16:00:00 GMT", (Object)responseCookies.get("userName"));
        Assert.assertEquals((Object)"userId=1; Version=1; Domain=localhost; Path=/; Secure; Expires=Sun, 1-Dec-2013 16:00:00 GMT", (Object)responseCookies.get("userId"));
    }

    @Test
    public void testHttpResponseBuilderCookiesWithExpressions() throws Exception {
        HttpResponseBuilder httpResponseBuilder = this.createHttpResponseBuilder();
        ArrayList<CookieWrapper> cookies = new ArrayList<CookieWrapper>();
        cookies.add(this.createCookie(HEADER_NAME, HEADER_VALUE, HEADER_DOMAIN, HEADER_PATH, HEADER_EXPIRY_DATE, HEADER_SECURE, HEADER_VERSION));
        httpResponseBuilder.setCookies(cookies);
        Mockito.when((Object)this.mockExpressionManager.parse(HEADER_NAME, this.mockMuleMessage)).thenReturn((Object)"userName");
        Mockito.when((Object)this.mockExpressionManager.parse(HEADER_VALUE, this.mockMuleMessage)).thenReturn((Object)"John_Galt");
        Mockito.when((Object)this.mockExpressionManager.parse(HEADER_DOMAIN, this.mockMuleMessage)).thenReturn((Object)"localhost");
        Mockito.when((Object)this.mockExpressionManager.parse(HEADER_PATH, this.mockMuleMessage)).thenReturn((Object)"/");
        Mockito.when((Object)this.mockExpressionManager.isExpression(HEADER_EXPIRY_DATE)).thenReturn((Object)true);
        Mockito.when((Object)this.mockExpressionManager.evaluate(HEADER_EXPIRY_DATE, this.mockMuleMessage)).thenReturn((Object)"Sun, 15 Dec 2013 16:00:00 GMT");
        Mockito.when((Object)this.mockExpressionManager.parse(HEADER_SECURE, this.mockMuleMessage)).thenReturn((Object)"true");
        Mockito.when((Object)this.mockExpressionManager.parse(HEADER_VERSION, this.mockMuleMessage)).thenReturn((Object)"1");
        HttpResponse response = new HttpResponse();
        httpResponseBuilder.setCookies(response, this.mockMuleMessage);
        Map<String, String> responseCookies = this.getHeaderCookie(response.getHeaders());
        Assert.assertNotNull(responseCookies);
        Assert.assertEquals((Object)"userName=John_Galt; Version=1; Domain=localhost; Path=/; Secure; Expires=Sun, 15-Dec-2013 16:00:00 GMT", (Object)responseCookies.get("userName"));
    }

    @Test
    public void testHttpResponseDefaultVersion() throws Exception {
        HttpResponseBuilder httpResponseBuilder = this.createHttpResponseBuilder();
        Mockito.when((Object)this.mockMuleMessage.getInboundProperty("http.version")).thenReturn((Object)"HTTP/1.0");
        httpResponseBuilder.checkVersion(this.mockMuleMessage);
        Assert.assertEquals((Object)"HTTP/1.0", (Object)httpResponseBuilder.getVersion());
    }

    @Test
    public void testHttpResponseDefaultContentType() throws Exception {
        HttpResponseBuilder httpResponseBuilder = this.createHttpResponseBuilder();
        Mockito.when((Object)this.mockMuleMessage.getInboundProperty("Content-Type")).thenReturn((Object)"text/html");
        HttpResponse response = new HttpResponse();
        this.mockParse();
        httpResponseBuilder.setContentType(response, this.mockMuleMessage);
        this.validateHeader(response.getHeaders(), "Content-Type", "text/html");
    }

    @Test
    public void testHttpResponseEmptyCacheControl() throws Exception {
        HttpResponseBuilder httpResponseBuilder = this.createHttpResponseBuilder();
        httpResponseBuilder.setCacheControl(new CacheControlHeader());
        HttpResponse response = new HttpResponse();
        httpResponseBuilder.setCacheControl(response, this.mockMuleMessage);
        Assert.assertNull((Object)response.getFirstHeader("Cache-Control"));
    }

    @Test
    public void testHttpResponseCacheControl() throws Exception {
        HttpResponseBuilder httpResponseBuilder = this.createHttpResponseBuilder();
        CacheControlHeader cacheControl = new CacheControlHeader();
        cacheControl.setDirective("public");
        cacheControl.setMaxAge("3600");
        cacheControl.setMustRevalidate("true");
        cacheControl.setNoCache("true");
        cacheControl.setNoStore("true");
        httpResponseBuilder.setCacheControl(cacheControl);
        this.mockParse();
        HttpResponse response = new HttpResponse();
        httpResponseBuilder.setCacheControl(response, this.mockMuleMessage);
        Assert.assertEquals((Object)"public,no-cache,no-store,must-revalidate,max-age=3600", (Object)response.getFirstHeader("Cache-Control").getValue());
    }

    @Test
    public void testHttpResponseCacheControlWithExpressions() throws Exception {
        HttpResponseBuilder httpResponseBuilder = this.createHttpResponseBuilder();
        CacheControlHeader cacheControl = new CacheControlHeader();
        cacheControl.setDirective(HEADER_DIRECTIVE);
        cacheControl.setMaxAge(HEADER_MAX_AGE);
        cacheControl.setMustRevalidate(HEADER_MUST_REVALIDATE);
        cacheControl.setNoCache(HEADER_NO_CACHE);
        cacheControl.setNoStore(HEADER_NO_STORE);
        httpResponseBuilder.setCacheControl(cacheControl);
        Mockito.when((Object)this.mockExpressionManager.parse(HEADER_DIRECTIVE, this.mockMuleMessage)).thenReturn((Object)"public");
        Mockito.when((Object)this.mockExpressionManager.parse(HEADER_MAX_AGE, this.mockMuleMessage)).thenReturn((Object)"3600");
        Mockito.when((Object)this.mockExpressionManager.parse(HEADER_MUST_REVALIDATE, this.mockMuleMessage)).thenReturn((Object)"true");
        Mockito.when((Object)this.mockExpressionManager.parse(HEADER_NO_CACHE, this.mockMuleMessage)).thenReturn((Object)"true");
        Mockito.when((Object)this.mockExpressionManager.parse(HEADER_NO_STORE, this.mockMuleMessage)).thenReturn((Object)"true");
        HttpResponse response = new HttpResponse();
        httpResponseBuilder.setCacheControl(response, this.mockMuleMessage);
        Assert.assertEquals((Object)"public,no-cache,no-store,must-revalidate,max-age=3600", (Object)response.getFirstHeader("Cache-Control").getValue());
    }

    @Test
    public void testHttpResponseCacheControlWithExtension() throws Exception {
        HttpResponseBuilder httpResponseBuilder = this.createHttpResponseBuilder();
        CacheControlHeader cacheControl = new CacheControlHeader();
        cacheControl.setMaxAge("3600");
        httpResponseBuilder.setCacheControl(cacheControl);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Cache-Control", "smax-age=3600");
        httpResponseBuilder.setHeaders(headers);
        this.mockParse();
        HttpResponse response = new HttpResponse();
        httpResponseBuilder.setHeaders(response, this.mockMuleMessage);
        httpResponseBuilder.setCacheControl(response, this.mockMuleMessage);
        Assert.assertEquals((Object)"max-age=3600,smax-age=3600", (Object)response.getFirstHeader("Cache-Control").getValue());
    }

    @Test
    public void testHttpResponseCopyOutboundProperties() throws Exception {
        Header[] headers;
        HttpResponseBuilder httpResponseBuilder = this.createHttpResponseBuilder();
        HashMap<String, Object> outboundProperties = new HashMap<String, Object>();
        outboundProperties.put("Age", "12");
        outboundProperties.put("Cache-Control", "max-age=3600");
        outboundProperties.put("MULE_ENCODING", "UTF-8");
        Cookie[] cookies = new Cookie[]{new Cookie(null, "clientId", "2"), new Cookie(null, "category", "premium")};
        outboundProperties.put("Set-Cookie", cookies);
        Set propertyNames = outboundProperties.keySet();
        Mockito.when((Object)this.mockMuleMessage.getOutboundPropertyNames()).thenReturn(propertyNames);
        for (String propertyName : propertyNames) {
            Mockito.when((Object)this.mockMuleMessage.getOutboundProperty(propertyName)).thenReturn(outboundProperties.get(propertyName));
        }
        HttpResponse response = new HttpResponse();
        httpResponseBuilder.copyOutboundProperties(response, this.mockMuleMessage);
        for (Header header : headers = response.getHeaders()) {
            if ("Set-Cookie".equals(header.getName())) {
                if (header.getValue().startsWith(cookies[0].getName())) {
                    Assert.assertEquals((Object)cookies[0].toString(), (Object)header.getValue());
                    continue;
                }
                Assert.assertEquals((Object)cookies[1].toString(), (Object)header.getValue());
                continue;
            }
            if (header.getName().startsWith("X-")) {
                Assert.assertEquals(outboundProperties.get(header.getName().substring("X-".length())), (Object)header.getValue());
                continue;
            }
            Assert.assertEquals(outboundProperties.get(header.getName()), (Object)header.getValue());
        }
    }

    @Test
    public void testHttpResponseWithOutboundProperties() throws Exception {
        HttpResponseBuilder httpResponseBuilder = this.createHttpResponseBuilder();
        CacheControlHeader cacheControl = new CacheControlHeader();
        cacheControl.setMaxAge("3600");
        httpResponseBuilder.setCacheControl(cacheControl);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Cache-Control", "public");
        headers.put("Age", "12");
        httpResponseBuilder.setHeaders(headers);
        HashMap<String, String> outboundProperties = new HashMap<String, String>();
        outboundProperties.put("Cache-Control", "no-cache");
        outboundProperties.put("Age", "20");
        outboundProperties.put("Location", "http://localhost:9090");
        this.mockParse();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)HTTP_BODY, outboundProperties, this.muleContext);
        Mockito.when((Object)this.mockEvent.getMessage()).thenReturn((Object)message);
        HttpResponse httpResponse = (HttpResponse)httpResponseBuilder.process(this.mockEvent).getMessage().getPayload();
        Header[] resultHeaders = httpResponse.getHeaders();
        this.validateHeader(resultHeaders, "Cache-Control", "max-age=3600,public");
        this.validateHeader(resultHeaders, "Age", "12");
        this.validateHeader(resultHeaders, "Location", "http://localhost:9090");
    }

    @Test
    public void testHttpResponseWithDateExpression() throws Exception {
        HttpResponseBuilder httpResponseBuilder = this.createHttpResponseBuilder();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Expires", "#[now]");
        httpResponseBuilder.setHeaders(headers);
        Date now = new Date();
        Mockito.when((Object)this.mockExpressionManager.parse("Expires", this.mockMuleMessage)).thenReturn((Object)"Expires");
        Mockito.when((Object)this.mockExpressionManager.isExpression("#[now]")).thenReturn((Object)true);
        Mockito.when((Object)this.mockExpressionManager.evaluate("#[now]", this.mockMuleMessage)).thenReturn((Object)now);
        HttpResponse httpResponse = new HttpResponse();
        httpResponseBuilder.setHeaders(httpResponse, this.mockMuleMessage);
        SimpleDateFormat httpDateFormatter = new SimpleDateFormat("EEE, dd MMM yyyy hh:mm:ss zzz", Locale.US);
        httpDateFormatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.validateHeader(httpResponse.getHeaders(), "Expires", httpDateFormatter.format(now));
    }

    @Test
    public void testHttpResponseCookieWithDateBuilder() throws Exception {
        HttpResponseBuilder httpResponseBuilder = this.createHttpResponseBuilder();
        Date now = new Date();
        ArrayList<CookieWrapper> cookies = new ArrayList<CookieWrapper>();
        cookies.add(this.createCookie("test", "test", null, null, "#[now]", null, null));
        httpResponseBuilder.setCookies(cookies);
        Mockito.when((Object)this.mockExpressionManager.isExpression("#[now]")).thenReturn((Object)true);
        Mockito.when((Object)this.mockExpressionManager.evaluate("#[now]", this.mockMuleMessage)).thenReturn((Object)now);
        Mockito.when((Object)this.mockExpressionManager.parse("test", this.mockMuleMessage)).thenReturn((Object)"test");
        Mockito.when((Object)this.mockExpressionManager.parse("test", this.mockMuleMessage)).thenReturn((Object)"test");
        HttpResponse response = new HttpResponse();
        httpResponseBuilder.setCookies(response, this.mockMuleMessage);
        SimpleDateFormat httpCookieFormatter = new SimpleDateFormat("EEE, d-MMM-yyyy HH:mm:ss z", Locale.US);
        httpCookieFormatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        String expectedCookieValue = "test=test; Expires=" + httpCookieFormatter.format(now);
        this.validateHeader(response.getHeaders(), "Set-Cookie", expectedCookieValue);
    }

    @Test
    public void testHttpResponseSetBodyWithHttpResponsePayload() throws Exception {
        HttpResponseBuilder httpResponseBuilder = this.createHttpResponseBuilder();
        HttpResponse response = new HttpResponse();
        response.setBody(HTTP_BODY);
        Mockito.when((Object)this.mockMuleMessage.getPayload()).thenReturn((Object)response);
        httpResponseBuilder.setBody(response, this.mockMuleMessage, this.mockEvent);
        Assert.assertEquals((Object)HTTP_BODY, (Object)response.getBodyAsString());
    }

    @Test
    public void testHttpResponseSetBody() throws Exception {
        HttpResponseBuilder httpResponseBuilder = this.createHttpResponseBuilder();
        HttpResponse response = new HttpResponse();
        Mockito.when((Object)this.mockMuleMessage.getPayload()).thenReturn((Object)HTTP_BODY);
        httpResponseBuilder.setBody(response, this.mockMuleMessage, this.mockEvent);
        Assert.assertEquals((Object)HTTP_BODY, (Object)response.getBodyAsString());
    }

    private CookieWrapper createCookie(String name, String value, String domain, String path, String expiryDate, String secure, String version) {
        CookieWrapper cookie = new CookieWrapper();
        cookie.setName(name);
        cookie.setValue(value);
        cookie.setDomain(domain);
        cookie.setPath(path);
        cookie.setExpiryDate((Object)expiryDate);
        cookie.setSecure(secure);
        cookie.setVersion(version);
        return cookie;
    }

    private Map<String, String> getHeaderCookie(Header[] headers) {
        HashMap<String, String> cookies = new HashMap<String, String>();
        for (Header header : headers) {
            if (!"Set-Cookie".equals(header.getName())) continue;
            cookies.put(header.getValue().split("=")[0], header.getValue());
        }
        return cookies;
    }

    private void validateHeaders(Header[] responseHeaders) {
        this.validateHeader(responseHeaders, "Cache-Control", "max-age=3600");
        this.validateHeader(responseHeaders, "Expires", "Thu, 01 Dec 1994 16:00:00 GMT");
        this.validateHeader(responseHeaders, "Location", "http://localhost:8080");
    }

    private HttpResponseBuilder createHttpResponseBuilder() throws InitialisationException {
        HttpResponseBuilder httpResponseBuilder = new HttpResponseBuilder();
        httpResponseBuilder.setMuleContext(this.muleContext);
        httpResponseBuilder.initialise();
        return httpResponseBuilder;
    }

    private void validateHeader(Header[] headers, String headerName, String expectedValue) {
        for (Header header : headers) {
            if (!headerName.equals(header.getName())) continue;
            Assert.assertEquals((Object)expectedValue, (Object)header.getValue());
            return;
        }
        Assert.fail((String)String.format("Didn't find header: %s=%s", headerName, expectedValue));
    }

    private void mockParse() {
        Mockito.when((Object)this.mockExpressionManager.parse(Matchers.anyString(), (MuleMessage)Mockito.any(MuleMessage.class))).thenAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                return invocation.getArguments()[0];
            }
        });
    }
}

