/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.components;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.transport.http.HttpRequest;
import org.mule.transport.http.functional.AbstractMockHttpServerTestCase;
import org.mule.transport.http.functional.MockHttpServer;
import org.mule.transport.http.functional.SingleRequestMockHttpServer;

public class RestServiceComponentDeleteTestCase
extends AbstractMockHttpServerTestCase {
    private CountDownLatch serverRequestCompleteLatch = new CountDownLatch(1);
    private boolean deleteRequestFound = false;
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    public RestServiceComponentDeleteTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "rest-service-component-delete-test-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "rest-service-component-delete-test-flow.xml"});
    }

    @Override
    protected MockHttpServer getHttpServer() {
        return new SimpleHttpServer(this.dynamicPort.getNumber());
    }

    @Test
    public void testRestServiceComponentDelete() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        client.send("vm://fromTest", (Object)"Test Message", null);
        Assert.assertTrue((boolean)this.serverRequestCompleteLatch.await(5000L, TimeUnit.MILLISECONDS));
        Assert.assertTrue((boolean)this.deleteRequestFound);
    }

    private class SimpleHttpServer
    extends SingleRequestMockHttpServer {
        public SimpleHttpServer(int listenPort) {
            super(listenPort, muleContext.getConfiguration().getDefaultEncoding());
        }

        @Override
        protected void processSingleRequest(HttpRequest httpRequest) throws Exception {
            RestServiceComponentDeleteTestCase.this.deleteRequestFound = httpRequest.getRequestLine().getMethod().equals("DELETE");
            RestServiceComponentDeleteTestCase.this.serverRequestCompleteLatch.countDown();
        }
    }
}

