/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import java.net.BindException;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.api.MuleContext;
import org.mule.tck.junit4.ApplicationContextBuilder;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.util.ExceptionUtils;

public class HttpSamePortTestCase {
    public static final String PATH_PROPERTY = "path";
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port");
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void twoApplicationCannotUseSamePort() throws Throwable {
        MuleContext firstMuleContext = null;
        MuleContext secondMuleContext = null;
        try {
            firstMuleContext = this.buildApp("helloWorld");
            this.thrown.expect(BindException.class);
            secondMuleContext = this.buildApp("helloMule");
            this.disposeQuietly(firstMuleContext);
            this.disposeQuietly(secondMuleContext);
        }
        catch (Exception e) {
            try {
                throw ExceptionUtils.getRootCause((Throwable)e);
            }
            catch (Throwable throwable) {
                this.disposeQuietly(firstMuleContext);
                this.disposeQuietly(secondMuleContext);
                throw throwable;
            }
        }
    }

    private void disposeQuietly(MuleContext muleContext) {
        try {
            muleContext.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MuleContext buildApp(String path) throws Exception {
        System.setProperty(PATH_PROPERTY, path);
        try {
            MuleContext muleContext = new ApplicationContextBuilder().setApplicationResources(new String[]{"http-same-port-config.xml"}).build();
            return muleContext;
        }
        finally {
            System.clearProperty(PATH_PROPERTY);
        }
    }
}

