/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.multipart;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import junit.framework.Assert;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.transport.http.multipart.MultiPartInputStream;
import org.mule.transport.http.multipart.MultipartConfiguration;
import org.mule.transport.http.multipart.Part;
import org.mule.util.FileUtils;
import org.mule.util.IOUtils;

public class MultiPartInputStreamTestCase
extends AbstractMuleTestCase {
    private static final String MULTIPART_BOUNDARY = "----------------------------299df9f9431b";
    private static final int NUMBER_OF_PARTS = 3;
    private static final String TMP_DIR = "./multipartTmpDir";
    private static File tmpDir;
    private static Set<String> partContents;
    private static String multipartMessage;

    @BeforeClass
    public static void setUp() throws IOException {
        tmpDir = MultiPartInputStreamTestCase.createTempDirectory(TMP_DIR);
        partContents = new HashSet<String>();
        StringBuilder multipartMessageBuilder = new StringBuilder();
        for (int i = 0; i < 3; ++i) {
            String partContent = "part " + i;
            partContents.add(partContent);
            multipartMessageBuilder.append("--").append(MULTIPART_BOUNDARY).append("\r\n");
            multipartMessageBuilder.append("Content-Disposition: form-data; name=\"").append(partContent).append("\"; filename=\"").append(partContent).append("\"\r\n");
            multipartMessageBuilder.append("Content-Type: application/octet-stream\r\n\r\n");
            multipartMessageBuilder.append(partContent).append("\r\n");
        }
        multipartMessage = multipartMessageBuilder.toString();
    }

    @AfterClass
    public static void tearDown() throws IOException {
        FileUtils.deleteDirectory((File)tmpDir);
    }

    @Test
    public void buildMultiPartInputStream() throws Exception {
        ByteArrayInputStream bis = new ByteArrayInputStream(multipartMessage.getBytes("UTF-8"));
        MultiPartInputStream mpis = new MultiPartInputStream((InputStream)bis, "multipart/form-data; boundary=----------------------------299df9f9431b", new MultipartConfiguration(TMP_DIR));
        Collection parts = mpis.getParts();
        Assert.assertEquals((int)3, (int)parts.size());
        HashSet<String> parsedPartContents = new HashSet<String>();
        for (Part part : parts) {
            InputStream pis = part.getInputStream();
            parsedPartContents.add(IOUtils.toString((InputStream)pis));
        }
        Assert.assertEquals(partContents, parsedPartContents);
        Assert.assertTrue((String)"Temporary directory should be empty", (boolean)FileUtils.listFiles((File)tmpDir, null, (boolean)false).isEmpty());
    }

    private static File createTempDirectory(String tmpDirName) throws IOException {
        File tmpDir = FileUtils.openDirectory((String)tmpDirName);
        FileUtils.deleteTree((File)tmpDir);
        return tmpDir;
    }
}

