/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.context.WorkManager;
import org.mule.transport.http.HttpMessageProcessTemplate;
import org.mule.transport.http.HttpMessageReceiver;
import org.mule.transport.http.HttpServerConnection;

@RunWith(value=MockitoJUnitRunner.class)
public class HttpMessageProcessTemplateTestCase {
    public static final String ENCODING = "UTF-8";
    public static final String PAYLOAD = "TEST PAYLOAD";
    public static final String ROOT_MESSAGE_ID = "myRootMessageId";
    public static final String CLIENT_ADDRESS = "1.1.1.1";
    public static final String PROXY_1_ADDRESS = "2.2.2.2";
    public static final String PROXY_2_ADDRESS = "3.3.3.3";
    public static final String CLIENT_ONLY_X_FORWARDED_FOR = "1.1.1.1";
    public static final String ONE_PROXY_X_FORWARDED_FOR = "1.1.1.1,2.2.2.2";
    public static final String TWO_PROXY_X_FORWARDED_FOR = "1.1.1.1,2.2.2.2,3.3.3.3";
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    HttpMessageReceiver messageReceiver;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    HttpServerConnection httpServerConnection;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    WorkManager flowExecutionWorkManager;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    MuleContext context;
    DefaultMuleMessage message;

    @Before
    public void prepare() throws MuleException {
        this.message = new DefaultMuleMessage((Object)PAYLOAD, this.context);
        this.message.setInboundProperty("MULE_ROOT_MESSAGE_ID", (Object)ROOT_MESSAGE_ID);
        this.message.setInboundProperty("http.request", (Object)"/");
        Mockito.when((Object)this.messageReceiver.getEndpoint().getEncoding()).thenReturn((Object)ENCODING);
        Mockito.when((Object)this.messageReceiver.createMuleMessage(Mockito.any(), Matchers.anyString())).thenReturn((Object)this.message);
        Mockito.when((Object)this.messageReceiver.getEndpoint().getEndpointURI().getAddress()).thenReturn((Object)"http://127.0.0.1/");
    }

    @Test
    public void checkCreateMessageFromSourceWithoutXForwardedFor() throws MuleException {
        Mockito.when((Object)this.httpServerConnection.getRemoteClientAddress()).thenReturn((Object)"1.1.1.1");
        HttpMessageProcessTemplate template = new HttpMessageProcessTemplate(this.messageReceiver, this.httpServerConnection);
        MuleMessage retMessage = template.createMessageFromSource((Object)PAYLOAD);
        Assert.assertThat((Object)retMessage, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)retMessage.getPayload(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)retMessage.getInboundProperty("MULE_REMOTE_CLIENT_ADDRESS"), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)"1.1.1.1")));
        Assert.assertThat((Object)retMessage.getInboundProperty("MULE_PROXY_ADDRESS"), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void checkCreateMessageFromSourceWithXForwardedForClientOnly() throws MuleException {
        Mockito.when((Object)this.httpServerConnection.getRemoteClientAddress()).thenReturn((Object)PROXY_1_ADDRESS);
        HttpMessageProcessTemplate template = new HttpMessageProcessTemplate(this.messageReceiver, this.httpServerConnection);
        this.message.setInboundProperty("X-Forwarded-For", (Object)"1.1.1.1");
        MuleMessage retMessage = template.createMessageFromSource((Object)PAYLOAD);
        Assert.assertThat((Object)retMessage, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)retMessage.getPayload(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)retMessage.getInboundProperty("MULE_REMOTE_CLIENT_ADDRESS"), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)"1.1.1.1")));
        Assert.assertThat((Object)retMessage.getInboundProperty("MULE_PROXY_ADDRESS"), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)PROXY_1_ADDRESS)));
    }

    @Test
    public void checkCreateMessageFromSourceWithXForwardedForOneProxy() throws MuleException {
        Mockito.when((Object)this.httpServerConnection.getRemoteClientAddress()).thenReturn((Object)PROXY_1_ADDRESS);
        HttpMessageProcessTemplate template = new HttpMessageProcessTemplate(this.messageReceiver, this.httpServerConnection);
        this.message.setInboundProperty("X-Forwarded-For", (Object)ONE_PROXY_X_FORWARDED_FOR);
        MuleMessage retMessage = template.createMessageFromSource((Object)PAYLOAD);
        Assert.assertThat((Object)retMessage, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)retMessage.getPayload(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)retMessage.getInboundProperty("MULE_REMOTE_CLIENT_ADDRESS"), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)"1.1.1.1")));
        Assert.assertThat((Object)retMessage.getInboundProperty("MULE_PROXY_ADDRESS"), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)PROXY_1_ADDRESS)));
    }

    @Test
    public void checkCreateMessageFromSourceWithXForwardedForTwoProxy() throws MuleException {
        Mockito.when((Object)this.httpServerConnection.getRemoteClientAddress()).thenReturn((Object)PROXY_2_ADDRESS);
        HttpMessageProcessTemplate template = new HttpMessageProcessTemplate(this.messageReceiver, this.httpServerConnection);
        this.message.setInboundProperty("X-Forwarded-For", (Object)TWO_PROXY_X_FORWARDED_FOR);
        MuleMessage retMessage = template.createMessageFromSource((Object)PAYLOAD);
        Assert.assertThat((Object)retMessage, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)retMessage.getPayload(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)retMessage.getInboundProperty("MULE_REMOTE_CLIENT_ADDRESS"), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)"1.1.1.1")));
        Assert.assertThat((Object)retMessage.getInboundProperty("MULE_PROXY_ADDRESS"), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)PROXY_2_ADDRESS)));
    }
}

