/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import java.util.HashMap;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class HttpPropertiesTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    protected String getConfigFile() {
        return "http-properties-conf.xml";
    }

    @Test
    public void testPropertiesGetMethod() throws Exception {
        GetMethod httpGet = new GetMethod("http://localhost:" + this.dynamicPort.getNumber() + "/resources/client?id=1");
        new HttpClient().executeMethod((HttpMethod)httpGet);
        String result = httpGet.getResponseBodyAsString();
        Assert.assertEquals((Object)"Retrieving client with id = 1", (Object)result);
    }

    @Test
    public void testPropertiesPostMethod() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("Content-Type", "application/x-www-form-urlencoded");
        MuleMessage response = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/resources/client", (MuleMessage)new DefaultMuleMessage((Object)"name=John&lastname=Galt", properties, muleContext));
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)"client", (Object)response.getInboundProperty("http.relative.path"));
        Assert.assertEquals((Object)("http://localhost:" + this.dynamicPort.getNumber() + "/resources"), (Object)response.getInboundProperty("http.context.uri"));
        Assert.assertEquals((Object)"Storing client with name = John and lastname = Galt", (Object)response.getPayloadAsString());
    }

    @Test
    public void testRedirectionWithRelativeProperty() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/redirect/products?retrieve=all&order=desc", (MuleMessage)new DefaultMuleMessage((Object)"Test Message", muleContext));
        Assert.assertEquals((Object)"Successfully redirected: products?retrieve=all&order=desc", (Object)response.getPayloadAsString());
    }
}

