/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class HttpHeadersTestCase
extends AbstractServiceAndFlowTestCase {
    @Rule
    public DynamicPort dynamicPort1 = new DynamicPort("port1");
    @Rule
    public DynamicPort dynamicPort2 = new DynamicPort("port2");

    public HttpHeadersTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "http-headers-config-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "http-headers-config-flow.xml"});
    }

    @Test
    public void testJettyHeaders() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send("clientEndpoint", (MuleMessage)new DefaultMuleMessage(null, muleContext));
        String contentTypeProperty = (String)result.getInboundProperty("Content-Type");
        Assert.assertNotNull((Object)contentTypeProperty);
        Assert.assertEquals((Object)"application/x-download", (Object)contentTypeProperty);
        String contentDispositionProperty = (String)result.getInboundProperty("Content-Disposition");
        Assert.assertNotNull((Object)contentDispositionProperty);
        Assert.assertEquals((Object)"attachment; filename=foo.zip", (Object)contentDispositionProperty);
    }
}

