/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.tck.junit4.rule.DynamicPort;

public class HttpPollingFunctionalTestCase
extends AbstractServiceAndFlowTestCase {
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    public HttpPollingFunctionalTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "mule-http-polling-config-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "mule-http-polling-config-flow.xml"});
    }

    @Test
    public void testPollingHttpConnector() throws Exception {
        FunctionalTestComponent ftc = this.getFunctionalTestComponent("polled");
        Assert.assertNotNull((Object)ftc);
        ftc.setEventCallback(new EventCallback(){

            public void eventReceived(MuleEventContext context, Object component) throws Exception {
                Assert.assertEquals((String)"The Accept header should be set on the incoming message", (Object)"application/xml", (Object)context.getMessage().getInboundProperty("Accept"));
            }
        });
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.request("vm://toclient", 5000L);
        Assert.assertNotNull((Object)result.getPayload());
        Assert.assertEquals((Object)"foo", (Object)result.getPayloadAsString());
    }
}

