/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.client.MuleClient;
import org.mule.api.client.OperationOptions;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.transport.DispatchException;
import org.mule.module.http.api.client.HttpRequestOptionsBuilder;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.util.ExceptionUtils;

public class HttpResponseTimeoutTestCase
extends AbstractServiceAndFlowTestCase {
    protected static String PAYLOAD = "Eugene";
    protected static int DEFAULT_RESPONSE_TIMEOUT = 2000;
    protected MuleClient muleClient;
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    public HttpResponseTimeoutTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "http-response-timeout-config-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "http-response-timeout-config-flow.xml"});
    }

    protected String getPayload() {
        return PAYLOAD;
    }

    protected String getProcessedPayload() {
        return this.getPayload() + " processed";
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.muleClient = muleContext.getClient();
    }

    @Test
    public void testDecreaseOutboundEndpointResponseTimeout() throws Exception {
        Date beforeCall = new Date();
        MuleMessage result = this.muleClient.send("vm://decreaseTimeoutRequest", (MuleMessage)this.getTestMessage());
        Assert.assertNotNull((Object)result);
        Assert.assertNotNull((Object)result.getExceptionPayload());
        Assert.assertEquals(DispatchException.class, result.getExceptionPayload().getException().getClass());
        Date afterCall = new Date();
        Assert.assertTrue((afterCall.getTime() - beforeCall.getTime() < (long)DEFAULT_RESPONSE_TIMEOUT ? 1 : 0) != 0);
    }

    private DefaultMuleMessage getTestMessage() {
        return new DefaultMuleMessage((Object)this.getPayload(), muleContext);
    }

    @Test
    public void testIncreaseOutboundEndpointResponseTimeout() throws Exception {
        Date beforeCall = new Date();
        MuleMessage message = this.muleClient.send("vm://increaseTimeoutRequest", (Object)this.getPayload(), null);
        Date afterCall = new Date();
        Assert.assertNotNull((Object)message);
        Assert.assertNull((Object)message.getExceptionPayload());
        Assert.assertNotNull((Object)message.getPayloadAsString());
        Assert.assertTrue((afterCall.getTime() - beforeCall.getTime() > (long)DEFAULT_RESPONSE_TIMEOUT ? 1 : 0) != 0);
    }

    @Test
    public void testDecreaseMuleClientSendResponseTimeout() throws Exception {
        Date beforeCall = new Date();
        try {
            this.muleClient.send(((InboundEndpoint)muleContext.getRegistry().lookupObject("inDelayService")).getAddress(), (MuleMessage)this.getTestMessage(), (OperationOptions)((HttpRequestOptionsBuilder)HttpRequestOptionsBuilder.newOptions().responseTimeout(1000L)).build());
            Assert.fail((String)"SocketTimeoutException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(ExceptionUtils.getRootCause((Throwable)e) instanceof TimeoutException));
        }
        Date afterCall = new Date();
        Assert.assertTrue((afterCall.getTime() - beforeCall.getTime() < (long)DEFAULT_RESPONSE_TIMEOUT ? 1 : 0) != 0);
    }

    @Test
    public void testIncreaseMuleClientSendResponseTimeout() throws Exception {
        Date beforeCall = new Date();
        MuleMessage message = this.muleClient.send(((InboundEndpoint)muleContext.getRegistry().lookupObject("inDelayService")).getAddress(), (MuleMessage)this.getTestMessage(), 3000L);
        Date afterCall = new Date();
        Assert.assertNotNull((Object)message);
        Assert.assertNull((Object)message.getExceptionPayload());
        Assert.assertNotNull((String)this.getProcessedPayload(), (Object)message.getPayloadAsString());
        Assert.assertTrue((afterCall.getTime() - beforeCall.getTime() > (long)DEFAULT_RESPONSE_TIMEOUT ? 1 : 0) != 0);
    }
}

