/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.httpclient.HttpParser;
import org.mule.transport.http.HttpRequest;
import org.mule.transport.http.RequestLine;

public abstract class MockHttpServer
implements Runnable {
    private static final long MOCK_HTTP_SERVER_TIMEOUT = 10000L;
    public static final String HTTP_STATUS_LINE_OK = "HTTP/1.1 200 OK\n";
    private final int listenPort;
    private final CountDownLatch startupLatch = new CountDownLatch(1);
    private final CountDownLatch shutdownLatch = new CountDownLatch(1);

    public MockHttpServer(int listenPort) {
        this.listenPort = listenPort;
    }

    protected abstract void processRequests(InputStream var1, OutputStream var2) throws Exception;

    @Override
    public void run() {
        try {
            ServerSocket serverSocket = new ServerSocket(this.listenPort);
            this.startupLatch.countDown();
            Socket clientSocket = serverSocket.accept();
            InputStream in = clientSocket.getInputStream();
            OutputStream out = clientSocket.getOutputStream();
            this.processRequests(in, out);
            in.close();
            out.close();
            clientSocket.close();
            serverSocket.close();
            this.shutdownLatch.countDown();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected HttpRequest parseRequest(InputStream in, String encoding) {
        try {
            String line = HttpParser.readLine((InputStream)in, (String)encoding);
            RequestLine requestLine = RequestLine.parseLine((String)line);
            return new HttpRequest(requestLine, HttpParser.parseHeaders((InputStream)in, (String)encoding), in, encoding);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean waitUntilServerStarted() throws Exception {
        return this.startupLatch.await(10000L, TimeUnit.MILLISECONDS);
    }

    public boolean waitUntilServerStopped() throws Exception {
        return this.shutdownLatch.await(10000L, TimeUnit.MILLISECONDS);
    }
}

