/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.api.MuleEvent;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.lifecycle.Callable;
import org.mule.construct.Flow;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class SessionPropertiesWithMessageCollectionTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort dynamicPort1 = new DynamicPort("port1");

    protected String getConfigFile() {
        return "session-properties-with-message-collection.xml";
    }

    @Test
    public void sessionPropertyAfterSplitterAndAggregator() throws MuleException {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("http://localhost:" + this.dynamicPort1.getNumber() + "/test", (Object)"Test Message", null);
        this.assertNotNullAndNotExceptionResponse(response);
    }

    @Test
    public void splitterAndAggregatorWithPersistentStore() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("synchronousCollectionAggregatorFlow");
        ArrayList<String> inputData = new ArrayList<String>();
        int numberOfElements = 10;
        for (int i = 0; i < numberOfElements; ++i) {
            inputData.add(String.valueOf(i));
        }
        MuleEvent responseEvent = flow.process(SessionPropertiesWithMessageCollectionTestCase.getTestEvent(inputData));
        Assert.assertThat((Object)((List)responseEvent.getSessionVariable("recordsToUpdate")).size(), (Matcher)Is.is((Object)numberOfElements));
    }

    private void assertNotNullAndNotExceptionResponse(MuleMessage response) {
        Assert.assertNotNull((Object)response);
        if (response.getExceptionPayload() != null) {
            Assert.fail((String)response.getExceptionPayload().getException().getCause().toString());
        }
    }

    public static class TestSplitterComponent
    implements Callable {
        public Object onCall(MuleEventContext eventContext) throws Exception {
            ArrayList<String> elements = new ArrayList<String>();
            for (int index = 0; index < 5; ++index) {
                elements.add("Element N" + index);
            }
            return elements;
        }
    }
}

