/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.transformers;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.transport.PropertyScope;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.transport.http.HttpResponse;
import org.mule.transport.http.transformers.MuleMessageToHttpResponse;

@SmallTest
public class MuleMessageToHttpResponseTestCase
extends AbstractMuleTestCase {
    @Test
    public void testSetCookieOnOutbound() throws Exception {
        MuleMessageToHttpResponse transformer = this.getMuleMessageToHttpResponse();
        MuleMessage msg = (MuleMessage)Mockito.mock(MuleMessage.class);
        Cookie[] cookiesOutbound = new Cookie[]{new Cookie("domain", "name-out-1", "value-out-1"), new Cookie("domain", "name-out-2", "value-out-2")};
        Mockito.when((Object)msg.getOutboundProperty("Set-Cookie")).thenReturn((Object)cookiesOutbound);
        HashSet<String> props = new HashSet<String>();
        props.add("Set-Cookie");
        Mockito.when((Object)msg.getOutboundPropertyNames()).thenReturn(props);
        HttpResponse response = transformer.createResponse(null, "UTF-8", msg);
        Header[] headers = response.getHeaders();
        int cookiesSet = 0;
        for (Header header : headers) {
            if (!"Set-Cookie".equals(header.getName())) continue;
            ++cookiesSet;
        }
        Assert.assertThat((Object)cookiesSet, (Matcher)CoreMatchers.equalTo((Object)cookiesOutbound.length));
    }

    @Test
    public void testSetDateOnOutbound() throws Exception {
        MuleMessageToHttpResponse transformer = this.getMuleMessageToHttpResponse();
        MuleMessage msg = (MuleMessage)Mockito.mock(MuleMessage.class);
        HttpResponse response = transformer.createResponse(null, "UTF-8", msg);
        Header[] headers = response.getHeaders();
        boolean hasDateHeader = false;
        for (Header header : headers) {
            if (!"Date".equals(header.getName())) continue;
            hasDateHeader = true;
            SimpleDateFormat formatter = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.US);
            formatter.setLenient(false);
            try {
                formatter.parse(header.getValue());
            }
            catch (ParseException e) {
                formatter.setLenient(true);
                formatter.parse(header.getValue());
            }
        }
        Assert.assertThat((String)"Missing 'Date' header", (Object)hasDateHeader, (Matcher)Is.is((Object)true));
    }

    @Test
    public void testContentTypeOnOutbound() throws Exception {
        MuleMessageToHttpResponse transformer = this.getMuleMessageToHttpResponse();
        String contentType = "text/xml";
        String wrongContentType = "text/json";
        HashMap<String, String> outboundProperties = new HashMap<String, String>();
        outboundProperties.put("Content-Type", "text/json");
        MuleContext muleContext = (MuleContext)Mockito.mock(MuleContext.class);
        DefaultMuleMessage msg = new DefaultMuleMessage(null, outboundProperties, muleContext);
        msg.setInvocationProperty("Content-Type", (Object)"text/json");
        msg.setProperty("Content-Type", (Object)"text/json", PropertyScope.INBOUND);
        msg.setOutboundProperty("Content-Type", (Object)"text/xml");
        HttpResponse response = transformer.createResponse(null, "UTF-8", (MuleMessage)msg);
        Header[] headers = response.getHeaders();
        boolean hasContentTypeHeader = false;
        for (Header header : headers) {
            if (!"Content-Type".equals(header.getName())) continue;
            hasContentTypeHeader = true;
            Assert.assertThat((Object)header.getValue(), (Matcher)Is.is((Matcher)CoreMatchers.equalTo((Object)"text/xml")));
        }
        Assert.assertThat((String)"MissingContent-Type header", (Object)hasContentTypeHeader, (Matcher)Is.is((Object)true));
    }

    private MuleMessageToHttpResponse getMuleMessageToHttpResponse() throws Exception {
        MuleMessageToHttpResponse transformer = new MuleMessageToHttpResponse();
        transformer.initialise();
        return transformer;
    }
}

