/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.components;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.ProtocolException;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transformer.Transformer;
import org.mule.processor.AbstractMessageProcessorOwner;
import org.mule.transformer.AbstractTransformer;
import org.mule.transport.http.CacheControlHeader;
import org.mule.transport.http.CookieHelper;
import org.mule.transport.http.CookieWrapper;
import org.mule.transport.http.HttpConstants;
import org.mule.transport.http.HttpResponse;
import org.mule.transport.http.i18n.HttpMessages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpResponseBuilder
extends AbstractMessageProcessorOwner
implements Initialisable,
MessageProcessor {
    private static final Logger logger = LoggerFactory.getLogger(HttpResponseBuilder.class);
    private Map<String, String> headers = new HashMap<String, String>();
    private List<CookieWrapper> cookies = new ArrayList<CookieWrapper>();
    private String contentType;
    private String status;
    private String version;
    private CacheControlHeader cacheControl;
    private boolean propagateMuleProperties = false;
    private AbstractTransformer bodyTransformer;
    private SimpleDateFormat expiresHeaderFormatter;
    private SimpleDateFormat dateFormatter;
    private List<MessageProcessor> ownedMessageProcessor = new ArrayList<MessageProcessor>();

    public void initialise() throws InitialisationException {
        super.initialise();
        this.expiresHeaderFormatter = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.US);
        this.expiresHeaderFormatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        if (HttpConstants.SERVER_TIME_ZONE_PROPERTY.isEnabled()) {
            logger.warn(HttpMessages.dateInServerTimeZone().getMessage());
            this.dateFormatter = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.US);
        } else {
            this.dateFormatter = this.expiresHeaderFormatter;
        }
    }

    public MuleEvent process(MuleEvent event) throws MuleException {
        MuleMessage msg = event.getMessage();
        HttpResponse httpResponse = this.getHttpResponse(msg);
        this.propagateMessageProperties(httpResponse, msg);
        this.checkVersion(msg);
        this.setStatus(httpResponse, msg);
        this.setContentType(httpResponse, msg);
        this.setHeaders(httpResponse, msg);
        this.setCookies(httpResponse, msg);
        this.setCacheControl(httpResponse, msg);
        this.setDateHeader(httpResponse, new Date());
        this.setBody(httpResponse, msg, event);
        msg.setPayload((Object)httpResponse);
        return event;
    }

    protected void setDateHeader(HttpResponse httpResponse, Date date) {
        httpResponse.setHeader(new Header("Date", this.dateFormatter.format(date)));
    }

    protected List<MessageProcessor> getOwnedMessageProcessors() {
        return this.ownedMessageProcessor;
    }

    protected void setBody(HttpResponse response, MuleMessage message, MuleEvent event) throws MuleException {
        if (this.bodyTransformer != null) {
            message.applyTransformers(event, new Transformer[]{this.bodyTransformer});
        }
        try {
            if (!(message.getPayload() instanceof HttpResponse)) {
                response.setBody(message);
            }
        }
        catch (Exception e) {
            throw new DefaultMuleException((Throwable)e);
        }
    }

    private void propagateMessageProperties(HttpResponse response, MuleMessage message) {
        this.copyOutboundProperties(response, message);
        if (this.propagateMuleProperties) {
            this.copyCorrelationIdProperties(response, message);
            this.copyReplyToProperty(response, message);
        }
    }

    private void copyCorrelationIdProperties(HttpResponse response, MuleMessage message) {
        if (message.getCorrelationId() != null) {
            response.setHeader(new Header("X-MULE_CORRELATION_ID", message.getCorrelationId()));
            response.setHeader(new Header("X-MULE_CORRELATION_GROUP_SIZE", String.valueOf(message.getCorrelationGroupSize())));
            response.setHeader(new Header("X-MULE_CORRELATION_SEQUENCE", String.valueOf(message.getCorrelationSequence())));
        }
    }

    private void copyReplyToProperty(HttpResponse response, MuleMessage message) {
        if (message.getReplyTo() != null) {
            response.setHeader(new Header("X-MULE_REPLYTO", message.getReplyTo().toString()));
        }
    }

    protected void copyOutboundProperties(HttpResponse response, MuleMessage message) {
        for (String headerName : message.getOutboundPropertyNames()) {
            Object headerValue = message.getOutboundProperty(headerName);
            if (headerValue == null) continue;
            if (this.isMuleProperty(headerName)) {
                if (!this.propagateMuleProperties) continue;
                this.addMuleHeader(response, headerName, headerValue);
                continue;
            }
            if (this.isMultiValueCookie(headerName, headerValue)) {
                this.addMultiValueCookie(response, (Cookie[])headerValue);
                continue;
            }
            response.setHeader(new Header(headerName, headerValue.toString()));
        }
    }

    private void addMuleHeader(HttpResponse response, String headerName, Object headerValue) {
        response.setHeader(new Header("X-" + headerName, headerValue.toString()));
    }

    private boolean isMuleProperty(String headerName) {
        return headerName.startsWith("MULE_");
    }

    private void addMultiValueCookie(HttpResponse response, Cookie[] cookies) {
        Cookie[] arrayOfCookies;
        for (Cookie cookie : arrayOfCookies = CookieHelper.asArrayOfCookies(cookies)) {
            response.addHeader(new Header("Set-Cookie", CookieHelper.formatCookieForASetCookieHeader(cookie)));
        }
    }

    private boolean isMultiValueCookie(String headerName, Object headerValue) {
        return "Set-Cookie".equals(headerName) && headerValue instanceof Cookie[];
    }

    private HttpResponse getHttpResponse(MuleMessage message) {
        HttpResponse httpResponse = message.getPayload() instanceof HttpResponse ? (HttpResponse)message.getPayload() : new HttpResponse();
        return httpResponse;
    }

    protected void setCacheControl(HttpResponse response, MuleMessage message) {
        if (this.cacheControl != null) {
            this.cacheControl.parse(message, this.muleContext.getExpressionManager());
            String cacheControlValue = this.cacheControl.toString();
            if (!"".equals(cacheControlValue)) {
                Header cacheControlHeader;
                if (this.headers.get("Cache-Control") != null && (cacheControlHeader = response.getFirstHeader("Cache-Control")) != null) {
                    cacheControlValue = cacheControlValue + "," + cacheControlHeader.getValue();
                }
                response.setHeader(new Header("Cache-Control", cacheControlValue));
            }
        }
    }

    protected void setCookies(HttpResponse response, MuleMessage message) throws MuleException {
        if (!this.cookies.isEmpty()) {
            for (CookieWrapper cookie : this.cookies) {
                try {
                    cookie.parse(message, this.muleContext.getExpressionManager());
                    response.addHeader(new Header("Set-Cookie", CookieHelper.formatCookieForASetCookieHeader(cookie.createCookie())));
                }
                catch (Exception e) {
                    throw new DefaultMuleException((Throwable)e);
                }
            }
        }
    }

    protected void setHeaders(HttpResponse response, MuleMessage message) {
        if (this.headers != null && !this.headers.isEmpty()) {
            for (String headerName : this.headers.keySet()) {
                String name = this.parse(headerName, message);
                String value = this.headers.get(headerName);
                if ("Expires".equals(name)) {
                    response.setHeader(new Header(name, this.evaluateDate(value, message)));
                    continue;
                }
                response.setHeader(new Header(name, this.parse(value, message)));
            }
        }
    }

    protected void checkVersion(MuleMessage message) {
        this.version = (String)message.getInboundProperty("http.version");
        if (this.version == null) {
            this.version = "HTTP/1.1";
        }
    }

    private void setStatus(HttpResponse response, MuleMessage message) throws MuleException {
        if (this.status != null) {
            try {
                response.setStatusLine(HttpVersion.parse((String)this.version), Integer.valueOf(this.parse(this.status, message)));
            }
            catch (ProtocolException e) {
                throw new DefaultMuleException((Throwable)e);
            }
        }
    }

    protected void setContentType(HttpResponse response, MuleMessage message) {
        if (this.contentType == null) {
            this.contentType = this.getDefaultContentType(message);
        }
        response.setHeader(new Header("Content-Type", this.parse(this.contentType, message)));
    }

    private String parse(String value, MuleMessage message) {
        if (value != null) {
            return this.muleContext.getExpressionManager().parse(value, message);
        }
        return value;
    }

    private String evaluateDate(String value, MuleMessage message) {
        Object realValue = value;
        if (value != null && this.muleContext.getExpressionManager().isExpression(value)) {
            realValue = this.muleContext.getExpressionManager().evaluate(value, message);
        }
        if (realValue instanceof Date) {
            return this.expiresHeaderFormatter.format(realValue);
        }
        return String.valueOf(realValue);
    }

    private String getDefaultContentType(MuleMessage message) {
        String contentType = (String)message.getInboundProperty("Content-Type");
        if (contentType == null) {
            contentType = "text/plain";
        }
        return contentType;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers.putAll(headers);
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setCookies(List<CookieWrapper> cookies) {
        this.cookies = cookies;
    }

    public void addHeader(String key, String value) {
        this.headers.put(key, value);
    }

    public void setCacheControl(CacheControlHeader cacheControl) {
        this.cacheControl = cacheControl;
    }

    public String getVersion() {
        return this.version;
    }

    public void setPropagateMuleProperties(boolean propagateMuleProperties) {
        this.propagateMuleProperties = propagateMuleProperties;
    }

    public void setMessageProcessor(MessageProcessor messageProcessor) {
        this.bodyTransformer = (AbstractTransformer)messageProcessor;
        this.ownedMessageProcessor.add((MessageProcessor)this.bodyTransformer);
    }
}

