/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.service.Service;
import org.mule.api.transport.Connector;
import org.mule.api.transport.ConnectorException;
import org.mule.api.transport.MessageDispatcher;
import org.mule.api.transport.MessageReceiver;
import org.mule.api.transport.NoReceiverForEndpointException;
import org.mule.endpoint.DefaultOutboundEndpoint;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.testmodels.fruit.Orange;
import org.mule.transport.AbstractConnectorTestCase;
import org.mule.transport.http.HttpConnector;
import org.mule.transport.http.HttpMessageReceiver;
import org.mule.transport.http.HttpRequest;
import org.mule.transport.http.RequestLine;
import org.mule.transport.tcp.TcpConnector;

@RunWith(value=MockitoJUnitRunner.class)
public class HttpConnectorTestCase
extends AbstractConnectorTestCase {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private static final String LISTENER_ALREADY_REGISTERED = "There is already a listener registered on this connector";
    private static final String ALL_INTERFACES_ENDPOINT_URI = "http://0.0.0.0:60127";
    private static final int MOCK_PORT = 5555;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private HttpMessageReceiver mockServiceOrderReceiverPort5555;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private HttpMessageReceiver mockServiceReceiverPort5555;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private HttpMessageReceiver mockServiceOrderReceiverPort7777;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private HttpMessageReceiver mockServiceReceiverPort7777;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private HttpMessageReceiver mockServiceReceiverAnotherHost;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private HttpMessageReceiver mockReceiverPort5555;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private HttpMessageReceiver mockAllInterfacesReceiverPort5555;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private HttpRequest mockHttpRequest;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private Socket mockSocket;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private RequestLine mockRequestLine;

    public Connector createConnector() throws Exception {
        HttpConnector c = new HttpConnector(muleContext);
        c.setName("HttpConnector");
        return c;
    }

    public String getTestEndpointURI() {
        return "http://localhost:60127";
    }

    public Object getValidMessage() throws Exception {
        return "Hello".getBytes();
    }

    @Test
    public void testValidListener() throws Exception {
        Service service = HttpConnectorTestCase.getTestService((String)"orange", Orange.class);
        InboundEndpoint endpoint = muleContext.getEndpointFactory().getInboundEndpoint(this.getTestEndpointURI());
        this.getConnector().registerListener(endpoint, (MessageProcessor)this.getSensingNullMessageProcessor(), (FlowConstruct)service);
    }

    @Test
    public void testInvalidListenerWhenAllInterfacesOneExists() throws Exception {
        this.testInvalidListener(ALL_INTERFACES_ENDPOINT_URI, this.getTestEndpointURI());
    }

    @Test
    public void testInvalidListenerWhenAddingAllInterfacesOne() throws Exception {
        this.testInvalidListener(this.getTestEndpointURI(), ALL_INTERFACES_ENDPOINT_URI);
    }

    private void testInvalidListener(String existingEndpointUri, String addedEndpointURI) throws Exception {
        this.thrown.expect(ConnectorException.class);
        this.thrown.expectMessage(Matchers.startsWith((String)LISTENER_ALREADY_REGISTERED));
        Service service = HttpConnectorTestCase.getTestService((String)"orange", Orange.class);
        InboundEndpoint allInterfacesEndpoint = muleContext.getEndpointFactory().getInboundEndpoint(existingEndpointUri);
        this.getConnector().registerListener(allInterfacesEndpoint, (MessageProcessor)this.getSensingNullMessageProcessor(), (FlowConstruct)service);
        InboundEndpoint endpoint = muleContext.getEndpointFactory().getInboundEndpoint(addedEndpointURI);
        this.getConnector().registerListener(endpoint, (MessageProcessor)this.getSensingNullMessageProcessor(), (FlowConstruct)service);
    }

    @Test
    public void testProperties() throws Exception {
        HttpConnector c = (HttpConnector)this.getConnector();
        c.setSendBufferSize(1024);
        Assert.assertEquals((long)1024L, (long)c.getSendBufferSize());
        c.setSendBufferSize(0);
        Assert.assertEquals((long)-1L, (long)c.getSendBufferSize());
        int maxDispatchers = c.getMaxTotalDispatchers();
        HttpConnectionManagerParams params = c.getClientConnectionManager().getParams();
        Assert.assertEquals((long)maxDispatchers, (long)params.getDefaultMaxConnectionsPerHost());
        Assert.assertEquals((long)maxDispatchers, (long)params.getMaxTotalConnections());
    }

    @Test
    public void findReceiverByStemConsideringAllInterfaces() throws Exception {
        Map<Object, MessageReceiver> receiversMap = this.createTestReceivers();
        Mockito.when((Object)this.mockAllInterfacesReceiverPort5555.getEndpointURI().getHost()).thenReturn((Object)"0.0.0.0");
        Assert.assertThat((Object)((HttpMessageReceiver)HttpConnector.findReceiverByStemConsideringMatchingHost(receiversMap, (String)"http://somehost:5555/")), (Matcher)Is.is((Object)this.mockReceiverPort5555));
        Assert.assertThat((Object)((HttpMessageReceiver)HttpConnector.findReceiverByStemConsideringMatchingHost(receiversMap, (String)"http://somehost:5555/extra")), (Matcher)Is.is((Object)this.mockReceiverPort5555));
        Assert.assertThat((Object)((HttpMessageReceiver)HttpConnector.findReceiverByStemConsideringMatchingHost(receiversMap, (String)"http://somehost:5555/service")), (Matcher)Is.is((Object)this.mockServiceReceiverPort5555));
        Assert.assertThat((Object)((HttpMessageReceiver)HttpConnector.findReceiverByStemConsideringMatchingHost(receiversMap, (String)"http://somehost:5555/serviceextra")), (Matcher)Is.is((Object)this.mockServiceReceiverPort5555));
        Assert.assertThat((Object)((HttpMessageReceiver)HttpConnector.findReceiverByStemConsideringMatchingHost(receiversMap, (String)"http://somehost:5555/service/order")), (Matcher)Is.is((Object)this.mockServiceOrderReceiverPort5555));
        Assert.assertThat((Object)((HttpMessageReceiver)HttpConnector.findReceiverByStemConsideringMatchingHost(receiversMap, (String)"http://somehost:5555/service/orderextra")), (Matcher)Is.is((Object)this.mockServiceOrderReceiverPort5555));
        Assert.assertThat((Object)((HttpMessageReceiver)HttpConnector.findReceiverByStemConsideringMatchingHost(receiversMap, (String)"http://somehost:7777/service/order")), (Matcher)Is.is((Object)this.mockServiceOrderReceiverPort7777));
        Assert.assertThat((Object)((HttpMessageReceiver)HttpConnector.findReceiverByStemConsideringMatchingHost(receiversMap, (String)"http://somehost:7777/service/orderextra")), (Matcher)Is.is((Object)this.mockServiceOrderReceiverPort7777));
        Assert.assertThat((Object)((HttpMessageReceiver)HttpConnector.findReceiverByStemConsideringMatchingHost(receiversMap, (String)"http://somehost:7777/service")), (Matcher)Is.is((Object)this.mockServiceReceiverPort7777));
        Assert.assertThat((Object)((HttpMessageReceiver)HttpConnector.findReceiverByStemConsideringMatchingHost(receiversMap, (String)"http://somehost:7777/serviceextra")), (Matcher)Is.is((Object)this.mockServiceReceiverPort7777));
        Assert.assertThat((Object)((HttpMessageReceiver)HttpConnector.findReceiverByStemConsideringMatchingHost(receiversMap, (String)"http://anotherhost:5555/")), (Matcher)Is.is((Object)this.mockServiceReceiverAnotherHost));
        Assert.assertThat((Object)((HttpMessageReceiver)HttpConnector.findReceiverByStemConsideringMatchingHost(receiversMap, (String)"http://anotherhost:5555/extra")), (Matcher)Is.is((Object)this.mockServiceReceiverAnotherHost));
        Assert.assertThat((Object)((HttpMessageReceiver)HttpConnector.findReceiverByStemConsideringMatchingHost(receiversMap, (String)"http://somehost:5555/a")), (Matcher)Is.is((Object)this.mockAllInterfacesReceiverPort5555));
        Assert.assertThat((Object)((HttpMessageReceiver)HttpConnector.findReceiverByStemConsideringMatchingHost(receiversMap, (String)"http://somehost:5555/all")), (Matcher)Is.is((Object)this.mockAllInterfacesReceiverPort5555));
    }

    @Test
    public void findReceiverByStem() throws Exception {
        Map<Object, MessageReceiver> receiversMap = this.createTestReceivers();
        Assert.assertThat((Object)((HttpMessageReceiver)HttpConnector.findReceiverByStem(receiversMap, (String)"http://somehost:5555/")), (Matcher)Is.is((Object)this.mockReceiverPort5555));
        Assert.assertThat((Object)((HttpMessageReceiver)HttpConnector.findReceiverByStem(receiversMap, (String)"http://somehost:5555/service")), (Matcher)Is.is((Object)this.mockServiceReceiverPort5555));
        Assert.assertThat((Object)((HttpMessageReceiver)HttpConnector.findReceiverByStem(receiversMap, (String)"http://somehost:5555/service/order")), (Matcher)Is.is((Object)this.mockServiceOrderReceiverPort5555));
        Assert.assertThat((Object)((HttpMessageReceiver)HttpConnector.findReceiverByStem(receiversMap, (String)"http://somehost:7777/service/order")), (Matcher)Is.is((Object)this.mockServiceOrderReceiverPort7777));
        Assert.assertThat((Object)((HttpMessageReceiver)HttpConnector.findReceiverByStem(receiversMap, (String)"http://somehost:7777/service")), (Matcher)Is.is((Object)this.mockServiceReceiverPort7777));
        Assert.assertThat((Object)((HttpMessageReceiver)HttpConnector.findReceiverByStem(receiversMap, (String)"http://anotherhost:5555/")), (Matcher)Is.is((Object)this.mockServiceReceiverAnotherHost));
    }

    private Map<Object, MessageReceiver> createTestReceivers() {
        HashMap<Object, MessageReceiver> receiversMap = new HashMap<Object, MessageReceiver>();
        this.addAndMock(receiversMap, (MessageReceiver)this.mockServiceOrderReceiverPort5555, "http://somehost:5555/service/order");
        this.addAndMock(receiversMap, (MessageReceiver)this.mockServiceReceiverPort5555, "http://somehost:5555/service");
        this.addAndMock(receiversMap, (MessageReceiver)this.mockReceiverPort5555, "http://somehost:5555/");
        this.addAndMock(receiversMap, (MessageReceiver)this.mockServiceOrderReceiverPort7777, "http://somehost:7777/service/order");
        this.addAndMock(receiversMap, (MessageReceiver)this.mockServiceReceiverPort7777, "http://somehost:7777/service");
        this.addAndMock(receiversMap, (MessageReceiver)this.mockServiceReceiverAnotherHost, "http://anotherhost:5555/");
        this.addAndMock(receiversMap, (MessageReceiver)this.mockAllInterfacesReceiverPort5555, "http://0.0.0.0:5555/a");
        return receiversMap;
    }

    private void addAndMock(Map<Object, MessageReceiver> receiversMap, MessageReceiver receiver, String receiverUri) {
        receiversMap.put(receiverUri, receiver);
        Mockito.when((Object)receiver.getEndpointURI().getUri()).thenReturn((Object)URI.create(receiverUri));
    }

    @Test
    public void lookupReceiverThatDoesNotExistsInThatPort() throws Exception {
        this.testLookupReceiver("somehost", 8888, "/management", null);
    }

    @Test
    public void lookupReceiverThatDoesNotExistsInThatHost() throws Exception {
        this.testLookupReceiver("nonexistenthost", 5555, "/service", null);
    }

    @Test
    public void lookupReceiverThatContainsPath() throws Exception {
        Mockito.when((Object)this.mockServiceReceiverPort5555.getEndpointURI().getPort()).thenReturn((Object)5555);
        Mockito.when((Object)this.mockServiceReceiverPort5555.getEndpointURI().getHost()).thenReturn((Object)"somehost");
        Mockito.when((Object)this.mockAllInterfacesReceiverPort5555.getEndpointURI().getPort()).thenReturn((Object)5555);
        Mockito.when((Object)this.mockAllInterfacesReceiverPort5555.getEndpointURI().getHost()).thenReturn((Object)"0.0.0.0");
        this.testLookupReceiver("somehost", 5555, "/service/product", this.mockServiceReceiverPort5555);
    }

    @Test
    public void lookupReceiverThatContainsPathAsAllInterfaces() throws Exception {
        Mockito.when((Object)this.mockServiceReceiverPort5555.getEndpointURI().getPort()).thenReturn((Object)5555);
        Mockito.when((Object)this.mockServiceReceiverPort5555.getEndpointURI().getHost()).thenReturn((Object)"somehost");
        Mockito.when((Object)this.mockAllInterfacesReceiverPort5555.getEndpointURI().getPort()).thenReturn((Object)5555);
        Mockito.when((Object)this.mockAllInterfacesReceiverPort5555.getEndpointURI().getHost()).thenReturn((Object)"0.0.0.0");
        this.testLookupReceiver("somehost", 5555, "/allinterfaces", this.mockAllInterfacesReceiverPort5555);
    }

    @Test
    public void lookupReceiverThatExistsWithExactSamePath() throws Exception {
        Mockito.when((Object)this.mockServiceReceiverPort5555.getEndpointURI().getPort()).thenReturn((Object)5555);
        Mockito.when((Object)this.mockServiceReceiverPort5555.getEndpointURI().getHost()).thenReturn((Object)"somehost");
        Mockito.when((Object)this.mockAllInterfacesReceiverPort5555.getEndpointURI().getPort()).thenReturn((Object)5555);
        Mockito.when((Object)this.mockAllInterfacesReceiverPort5555.getEndpointURI().getHost()).thenReturn((Object)"0.0.0.0");
        this.testLookupReceiver("somehost", 5555, "/service/order?param1=value1", this.mockServiceOrderReceiverPort5555);
    }

    @Test
    public void lookupReceiverThatExistsWithExactSamePathAsAllInterfaces() throws Exception {
        Mockito.when((Object)this.mockServiceReceiverPort5555.getEndpointURI().getPort()).thenReturn((Object)5555);
        Mockito.when((Object)this.mockServiceReceiverPort5555.getEndpointURI().getHost()).thenReturn((Object)"somehost");
        Mockito.when((Object)this.mockAllInterfacesReceiverPort5555.getEndpointURI().getPort()).thenReturn((Object)5555);
        Mockito.when((Object)this.mockAllInterfacesReceiverPort5555.getEndpointURI().getHost()).thenReturn((Object)"0.0.0.0");
        this.testLookupReceiver("somehost", 5555, "/a", this.mockAllInterfacesReceiverPort5555);
    }

    @Test
    public void lookupReceiverByRequestLineThatDoesNotExistsInThatPort() throws Exception {
        this.testLookupReceiverByRequestLine("somehost", 8888, "/management", null);
    }

    @Test
    public void lookupReceiverByRequestLineThatDoesNotExistsInThatHost() throws Exception {
        this.testLookupReceiverByRequestLine("nonexistenthost", 5555, "/service", null);
    }

    @Test
    public void lookupReceiverByRequestLineThatContainsPath() throws Exception {
        Mockito.when((Object)this.mockServiceReceiverPort5555.getEndpointURI().getPort()).thenReturn((Object)5555);
        Mockito.when((Object)this.mockServiceReceiverPort5555.getEndpointURI().getHost()).thenReturn((Object)"somehost");
        Mockito.when((Object)this.mockAllInterfacesReceiverPort5555.getEndpointURI().getPort()).thenReturn((Object)5555);
        Mockito.when((Object)this.mockAllInterfacesReceiverPort5555.getEndpointURI().getHost()).thenReturn((Object)"0.0.0.0");
        this.testLookupReceiverByRequestLine("somehost", 5555, "/service/product", this.mockServiceReceiverPort5555);
    }

    @Test
    public void lookupReceiverByRequestLineThatContainsPathAsAllInterfaces() throws Exception {
        Mockito.when((Object)this.mockServiceReceiverPort5555.getEndpointURI().getPort()).thenReturn((Object)5555);
        Mockito.when((Object)this.mockServiceReceiverPort5555.getEndpointURI().getHost()).thenReturn((Object)"somehost");
        Mockito.when((Object)this.mockAllInterfacesReceiverPort5555.getEndpointURI().getPort()).thenReturn((Object)5555);
        Mockito.when((Object)this.mockAllInterfacesReceiverPort5555.getEndpointURI().getHost()).thenReturn((Object)"0.0.0.0");
        this.testLookupReceiverByRequestLine("somehost", 5555, "/allinterfaces", this.mockAllInterfacesReceiverPort5555);
    }

    @Test
    public void lookupReceiverByRequestLineThatExistsWithExactSamePath() throws Exception {
        Mockito.when((Object)this.mockServiceReceiverPort5555.getEndpointURI().getPort()).thenReturn((Object)5555);
        Mockito.when((Object)this.mockServiceReceiverPort5555.getEndpointURI().getHost()).thenReturn((Object)"somehost");
        Mockito.when((Object)this.mockAllInterfacesReceiverPort5555.getEndpointURI().getPort()).thenReturn((Object)5555);
        Mockito.when((Object)this.mockAllInterfacesReceiverPort5555.getEndpointURI().getHost()).thenReturn((Object)"0.0.0.0");
        this.testLookupReceiverByRequestLine("somehost", 5555, "/service/order?param1=value1", this.mockServiceOrderReceiverPort5555);
    }

    @Test
    public void lookupReceiverByRequestLineThatExistsWithExactSamePathAsAllInterfaces() throws Exception {
        Mockito.when((Object)this.mockServiceReceiverPort5555.getEndpointURI().getPort()).thenReturn((Object)5555);
        Mockito.when((Object)this.mockServiceReceiverPort5555.getEndpointURI().getHost()).thenReturn((Object)"somehost");
        Mockito.when((Object)this.mockAllInterfacesReceiverPort5555.getEndpointURI().getPort()).thenReturn((Object)5555);
        Mockito.when((Object)this.mockAllInterfacesReceiverPort5555.getEndpointURI().getHost()).thenReturn((Object)"0.0.0.0");
        this.testLookupReceiverByRequestLine("somehost", 5555, "/a", this.mockAllInterfacesReceiverPort5555);
    }

    private void testLookupReceiver(String host, int port, String path, HttpMessageReceiver expectedMessageReceiver) {
        HttpConnector httpConnector = (HttpConnector)this.getConnector();
        httpConnector.getReceivers().putAll(this.createTestReceivers());
        Mockito.when((Object)this.mockHttpRequest.getRequestLine()).thenReturn((Object)this.mockRequestLine);
        Mockito.when((Object)this.mockRequestLine.getUrlWithoutParams()).thenReturn((Object)path);
        Mockito.when((Object)this.mockSocket.getLocalSocketAddress()).thenReturn((Object)new InetSocketAddress(host, port));
        Assert.assertThat((Object)httpConnector.lookupReceiver(this.mockSocket, this.mockHttpRequest), (Matcher)Is.is((Object)expectedMessageReceiver));
    }

    private void testLookupReceiverByRequestLine(String host, int port, String path, HttpMessageReceiver expectedMessageReceiver) throws NoReceiverForEndpointException {
        HttpConnector httpConnector = (HttpConnector)this.getConnector();
        httpConnector.getReceivers().putAll(this.createTestReceivers());
        Mockito.when((Object)this.mockRequestLine.getUrlWithoutParams()).thenReturn((Object)path);
        Mockito.when((Object)this.mockSocket.getLocalSocketAddress()).thenReturn((Object)new InetSocketAddress(host, port));
        if (expectedMessageReceiver != null) {
            Assert.assertThat((Object)httpConnector.lookupReceiver(this.mockSocket, this.mockRequestLine), (Matcher)Is.is((Object)expectedMessageReceiver));
        } else {
            try {
                httpConnector.lookupReceiver(this.mockSocket, this.mockRequestLine);
                Assert.fail((String)"exception should be thrown");
            }
            catch (NoReceiverForEndpointException e) {
                // empty catch block
            }
        }
    }

    @Test
    public void tcpNoDelayDefault() throws Exception {
        Assert.assertFalse((boolean)((TcpConnector)this.getConnector()).isSendTcpNoDelay());
    }

    @Test
    public void tcpNoDelayDefaultSystemPropertyTrue() throws Exception {
        MuleTestUtils.testWithSystemProperty((String)"mule.transport.tcp.defaultSendTcpNoDelay", (String)"true", (MuleTestUtils.TestCallback)new MuleTestUtils.TestCallback(){

            public void run() throws Exception {
                Assert.assertTrue((boolean)((HttpConnector)HttpConnectorTestCase.this.createConnector()).isSendTcpNoDelay());
            }
        });
    }

    @Test
    public void tcpNoDelayDefaultSystemPropertyFalse() throws Exception {
        MuleTestUtils.testWithSystemProperty((String)"mule.transport.tcp.defaultSendTcpNoDelay", (String)"false", (MuleTestUtils.TestCallback)new MuleTestUtils.TestCallback(){

            public void run() throws Exception {
                Assert.assertFalse((boolean)((HttpConnector)HttpConnectorTestCase.this.createConnector()).isSendTcpNoDelay());
            }
        });
    }

    @Test
    public void tcpNoDelayHttpClientConnectionManagerConfiguration() throws Exception {
        HttpConnector httpConnector = (HttpConnector)this.createConnector();
        httpConnector.initialise();
        Assert.assertFalse((boolean)httpConnector.clientConnectionManager.getParams().getTcpNoDelay());
        httpConnector = (HttpConnector)this.createConnector();
        httpConnector.setSendTcpNoDelay(true);
        httpConnector.initialise();
        Assert.assertTrue((boolean)httpConnector.clientConnectionManager.getParams().getTcpNoDelay());
    }

    @Test
    public void httpClientDisableStaleConnectionDefault() throws Exception {
        this.assertHttpClientStaleConnectionCheck(this.getInitialisedHttpConnector(), true);
    }

    @Test
    public void httpClientDisableStaleConnectionSystemProperty() throws Exception {
        MuleTestUtils.testWithSystemProperty((String)"mule.transport.http.disableHttpClientStaleConnectionCheck", (String)"true", (MuleTestUtils.TestCallback)new MuleTestUtils.TestCallback(){

            public void run() throws Exception {
                HttpConnectorTestCase.this.assertHttpClientStaleConnectionCheck(HttpConnectorTestCase.this.getInitialisedHttpConnector(), false);
            }
        });
    }

    protected HttpConnector getInitialisedHttpConnector() throws Exception, InitialisationException {
        HttpConnector httpConnector = (HttpConnector)this.createConnector();
        httpConnector.initialise();
        return httpConnector;
    }

    protected void assertHttpClientStaleConnectionCheck(HttpConnector connector, boolean enabled) throws Exception, InitialisationException {
        Assert.assertEquals((Object)enabled, (Object)connector.clientConnectionManager.getParams().isStaleCheckingEnabled());
    }

    public void singleDispatcherPerEndpointSyetemProperty() throws Exception {
        MuleTestUtils.testWithSystemProperty((String)"mule.transport.http.singleDispatcherPerEndpoint", (String)"true", (MuleTestUtils.TestCallback)new MuleTestUtils.TestCallback(){

            public void run() throws Exception {
                HttpConnector httpConnector = (HttpConnector)HttpConnectorTestCase.this.createConnector();
                httpConnector.initialise();
                OutboundEndpoint endpoint = muleContext.getEndpointFactory().getOutboundEndpoint("http://localhost:8080");
                httpConnector.createDispatcherMessageProcessor(endpoint);
                Assert.assertNotNull((Object)httpConnector.borrowDispatcher(endpoint));
                Assert.assertEquals((Object)httpConnector.borrowDispatcher(endpoint), (Object)httpConnector.borrowDispatcher(endpoint));
                Assert.assertEquals((long)0L, (long)httpConnector.getDispatchers().getNumIdle());
            }
        });
    }

    @Test
    public void dispatchersAreRemoved() throws Exception {
        DefaultOutboundEndpoint endpoint = (DefaultOutboundEndpoint)muleContext.getEndpointFactory().getOutboundEndpoint("http://localhost:8080");
        HttpConnector httpConnector = (HttpConnector)endpoint.getConnector();
        httpConnector.start();
        MessageDispatcher initialDispatcher = httpConnector.borrowDispatcher((OutboundEndpoint)endpoint);
        httpConnector.returnDispatcher((OutboundEndpoint)endpoint, initialDispatcher);
        MessageDispatcher shouldBeSameDispatcher = httpConnector.borrowDispatcher((OutboundEndpoint)endpoint);
        Assert.assertThat((Object)shouldBeSameDispatcher, (Matcher)Is.is((Matcher)Matchers.sameInstance((Object)initialDispatcher)));
        httpConnector.returnDispatcher((OutboundEndpoint)endpoint, shouldBeSameDispatcher);
        endpoint.getMessageProcessorChain(null);
        endpoint.dispose();
        MessageDispatcher shouldBeANewDispatcher = httpConnector.borrowDispatcher((OutboundEndpoint)endpoint);
        Assert.assertThat((Object)shouldBeANewDispatcher, (Matcher)IsNot.not((Matcher)Matchers.sameInstance((Object)initialDispatcher)));
        httpConnector.returnDispatcher((OutboundEndpoint)endpoint, shouldBeANewDispatcher);
    }
}

