/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.transport.http.HttpRequest;
import org.mule.transport.http.functional.AbstractMockHttpServerTestCase;
import org.mule.transport.http.functional.MockHttpServer;
import org.mule.transport.http.functional.SingleRequestMockHttpServer;

public class HttpCookieTestCase
extends AbstractMockHttpServerTestCase {
    private static final String EXPECTED_CUSTOM_COOKIE = "$Version=0; customCookie=yes";
    private static final String EXPECTED_EXPRESSION_COOKIE = "$Version=0; expressionCookie=MYCOOKIE";
    private CountDownLatch latch = new CountDownLatch(1);
    private boolean cookieFound = false;
    private List<String> cookieHeaders = new ArrayList<String>();
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    public HttpCookieTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "http-cookie-test-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "http-cookie-test-flow.xml"});
    }

    @Override
    protected MockHttpServer getHttpServer() {
        return new SimpleHttpServer(this.dynamicPort.getNumber());
    }

    @Test
    public void sendsCookiesFromMapInPathWithoutEncodedCharacters() throws Exception {
        this.doRequest("testPath", this.getCookieMap());
        this.assertCookiesReceived(EXPECTED_CUSTOM_COOKIE, EXPECTED_EXPRESSION_COOKIE);
    }

    @Test
    public void sendsCookiesFromMapInPathWithEncodedCharacters() throws Exception {
        this.doRequest("testPath%25", this.getCookieMap());
        this.assertCookiesReceived(EXPECTED_CUSTOM_COOKIE, EXPECTED_EXPRESSION_COOKIE);
    }

    @Test
    public void sendsCookiesFromArrayInPathWithoutEncodedCharacters() throws Exception {
        this.doRequest("testPath", this.getCookieArray());
        this.assertCookiesReceived(EXPECTED_CUSTOM_COOKIE);
    }

    @Test
    public void sendsCookiesFromArrayInPathWithEncodedCharacters() throws Exception {
        this.doRequest("testPath%25", this.getCookieArray());
        this.assertCookiesReceived(EXPECTED_CUSTOM_COOKIE);
    }

    private void doRequest(String path, Object cookiesObject) throws Exception {
        HashMap<String, Object> outboundProperties = new HashMap<String, Object>();
        outboundProperties.put("COOKIE_HEADER", "MYCOOKIE");
        outboundProperties.put("PATH", path);
        outboundProperties.put("cookies", cookiesObject);
        LocalMuleClient client = muleContext.getClient();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"Test Message", outboundProperties, muleContext);
        client.dispatch("vm://vm-in", (MuleMessage)message);
        Assert.assertTrue((boolean)this.latch.await(5000L, TimeUnit.MILLISECONDS));
        Assert.assertTrue((boolean)this.cookieFound);
    }

    private Map<String, String> getCookieMap() {
        HashMap<String, String> cookieMap = new HashMap<String, String>();
        cookieMap.put("customCookie", "yes");
        cookieMap.put("expressionCookie", "#[header:INBOUND:COOKIE_HEADER]");
        return cookieMap;
    }

    private Cookie[] getCookieArray() {
        Cookie[] cookieArray = new Cookie[]{new Cookie("localhost", "customCookie", "yes")};
        return cookieArray;
    }

    private void assertCookiesReceived(String ... cookies) {
        Assert.assertEquals((long)cookies.length, (long)this.cookieHeaders.size());
        for (String cookie : cookies) {
            this.assertThereIsCookieWithThisContent(cookie, this.cookieHeaders);
        }
    }

    private void assertThereIsCookieWithThisContent(String content, List<String> listOfRawCookies) {
        for (String rawCookie : listOfRawCookies) {
            if (rawCookie == null || !rawCookie.contains(content)) continue;
            return;
        }
        Assert.fail((String)("There should be a cookie with content '" + content + "': " + listOfRawCookies));
    }

    private class SimpleHttpServer
    extends SingleRequestMockHttpServer {
        public SimpleHttpServer(int listenPort) {
            super(listenPort, muleContext.getConfiguration().getDefaultEncoding());
        }

        @Override
        protected void processSingleRequest(HttpRequest httpRequest) throws Exception {
            for (Header header : httpRequest.getHeaders()) {
                if (!header.getName().equals("Cookie")) continue;
                HttpCookieTestCase.this.cookieFound = true;
                HttpCookieTestCase.this.cookieHeaders.add(header.getValue());
            }
            HttpCookieTestCase.this.latch.countDown();
        }
    }
}

