/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import javax.net.ssl.SSLHandshakeException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.api.transport.DispatchException;
import org.mule.construct.Flow;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;

public class HttpsMultipleConnectorsTestCase
extends FunctionalTestCase {
    private static final String TRUST_STORE_SYSTEM_PROPERTY = "javax.net.ssl.trustStore";
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port");
    @Rule
    public SystemProperty disablePropertiesMapping = new SystemProperty("mule.tls.disableSystemPropertiesMapping", "true");
    private String oldTrustStoreValue;

    protected String getConfigFile() {
        return "https-multiple-connectors-config.xml";
    }

    protected void doSetUpBeforeMuleContextCreation() throws Exception {
        super.doSetUpBeforeMuleContextCreation();
        this.oldTrustStoreValue = System.clearProperty(TRUST_STORE_SYSTEM_PROPERTY);
    }

    protected void doTearDownAfterMuleContextDispose() throws Exception {
        super.doTearDownAfterMuleContextDispose();
        if (this.oldTrustStoreValue != null) {
            System.setProperty(TRUST_STORE_SYSTEM_PROPERTY, this.oldTrustStoreValue);
        }
    }

    @Test
    public void connectorWithInvalidKeyStoreFails() throws Exception {
        Flow client = (Flow)this.getFlowConstruct("client");
        try {
            client.process(HttpsMultipleConnectorsTestCase.getTestEvent((Object)"Test Message"));
            Assert.fail();
        }
        catch (DispatchException e) {
            Assert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(SSLHandshakeException.class));
        }
    }
}

