/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import java.util.Arrays;
import org.mule.api.MuleMessage;
import org.mule.api.expression.ExpressionManager;

public class CacheControlHeader {
    private static final String[] DIRECTIVE = new String[]{"public", "private"};
    private String directive;
    private String noCache = "false";
    private String noStore = "false";
    private String mustRevalidate = "false";
    private String maxAge;

    public void parse(MuleMessage message, ExpressionManager expressionManager) {
        this.directive = this.parse(this.directive, message, expressionManager);
        this.checkDirective(this.directive);
        this.noCache = this.parse(this.noCache, message, expressionManager);
        this.noStore = this.parse(this.noStore, message, expressionManager);
        this.mustRevalidate = this.parse(this.mustRevalidate, message, expressionManager);
        this.maxAge = this.parse(this.maxAge, message, expressionManager);
    }

    private void checkDirective(String directive) {
        if (directive != null && !Arrays.asList(DIRECTIVE).contains(directive)) {
            throw new IllegalArgumentException("Invalid Cache-Control directive: " + directive);
        }
    }

    public String toString() {
        String value;
        StringBuilder cacheControl = new StringBuilder("");
        if (this.directive != null) {
            cacheControl.append(this.directive).append(",");
        }
        if (Boolean.valueOf(this.noCache).booleanValue()) {
            cacheControl.append("no-cache").append(",");
        }
        if (Boolean.valueOf(this.noStore).booleanValue()) {
            cacheControl.append("no-store").append(",");
        }
        if (Boolean.valueOf(this.mustRevalidate).booleanValue()) {
            cacheControl.append("must-revalidate").append(",");
        }
        if (this.maxAge != null) {
            cacheControl.append("max-age=").append(this.maxAge).append(",");
        }
        if ((value = cacheControl.toString()).endsWith(",")) {
            return value.substring(0, value.length() - 1);
        }
        return value;
    }

    private String parse(String value, MuleMessage message, ExpressionManager expressionManager) {
        if (value != null) {
            return expressionManager.parse(value, message);
        }
        return value;
    }

    public void setDirective(String directive) {
        this.directive = directive;
    }

    public void setNoCache(String noCache) {
        this.noCache = noCache;
    }

    public void setNoStore(String noStore) {
        this.noStore = noStore;
    }

    public void setMustRevalidate(String mustRevalidate) {
        this.mustRevalidate = mustRevalidate;
    }

    public void setMaxAge(String maxAge) {
        this.maxAge = maxAge;
    }
}

