/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.message.ds.ByteArrayDataSource;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class FileAttachmentNameTestCase
extends FunctionalTestCase {
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();
    @Rule
    public DynamicPort httpPort = new DynamicPort("httpPort");

    protected String getConfigFile() {
        return "file-attachment-name-config.xml";
    }

    @Test
    public void keepsAttachmentAndFileNames() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        DataHandler dataHandler = new DataHandler((DataSource)new ByteArrayDataSource("Test Message".getBytes(), "text/xml", "testAttachment.txt"));
        DefaultMuleMessage msg = new DefaultMuleMessage((Object)"Test Message", muleContext);
        msg.addOutboundAttachment("testAttachment", dataHandler);
        MuleMessage response = client.send("http://localhost:" + this.httpPort.getValue() + "/testInput", (MuleMessage)msg);
        MatcherAssert.assertThat((Object)response.getPayloadAsString(), (Matcher)Matchers.equalTo((Object)"testAttachment:testAttachment.txt"));
    }
}

