/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.StatusLine;
import org.apache.commons.httpclient.URI;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleMessage;
import org.mule.api.transport.MessageTypeNotSupportedException;
import org.mule.api.transport.MuleMessageFactory;
import org.mule.transport.AbstractMuleMessageFactoryTestCase;
import org.mule.transport.http.HttpMuleMessageFactory;
import org.mule.transport.http.HttpRequest;
import org.mule.transport.http.RequestLine;

public class HttpMuleMessageFactoryTestCase
extends AbstractMuleMessageFactoryTestCase {
    private static final Header[] HEADERS = new Header[]{new Header("foo-header", "foo-value")};
    private static final String[] COOKIES = new String[]{"COOKIE1=HEY", "cookie2=ho", "COOKIE3=LETS", "cookie4=go"};
    private static final String REQUEST_LINE = "GET /services/Echo HTTP/1.1";
    private static final String MULTIPART_BOUNDARY = "------------------------------2eab2c5d5c7e";
    private static final String MULTIPART_MESSAGE = "------------------------------2eab2c5d5c7e\nContent-Disposition: form-data; name=\"payload\"\nTest Message\n------------------------------2eab2c5d5c7e--";
    private static final String URI = "http://localhost/services/Echo";
    private static final String REQUEST = "/services/Echo?name=John&lastname=Galt";

    protected MuleMessageFactory doCreateMuleMessageFactory() {
        return new HttpMuleMessageFactory();
    }

    protected Object getValidTransportMessage() throws Exception {
        RequestLine requestLine = RequestLine.parseLine((String)REQUEST_LINE);
        HttpRequest request = new HttpRequest(requestLine, HEADERS, null, this.encoding);
        return request;
    }

    protected Object getUnsupportedTransportMessage() {
        return "this is not a valid transport message for HttpMuleMessageFactory";
    }

    public void testValidPayload() throws Exception {
        MuleMessageFactory factory = this.createMuleMessageFactory();
        Object payload = this.getValidTransportMessage();
        MuleMessage message = factory.create(payload, this.encoding, muleContext);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)"/services/Echo", (Object)message.getPayload());
        Assert.assertEquals((Object)"GET", (Object)message.getInboundProperty("http.method"));
        Assert.assertEquals((Object)"foo-value", (Object)message.getInboundProperty("foo-header"));
    }

    @Test(expected=MessageTypeNotSupportedException.class)
    public void testInvalidPayloadOnHttpMuleMessageFactory() throws Exception {
        HttpMuleMessageFactory factory = new HttpMuleMessageFactory();
        factory.extractPayload(this.getUnsupportedTransportMessage(), this.encoding);
    }

    @Test
    public void testHttpRequestPostPayload() throws Exception {
        HttpMuleMessageFactory factory = (HttpMuleMessageFactory)this.createMuleMessageFactory();
        factory.setExchangePattern(MessageExchangePattern.ONE_WAY);
        HttpRequest request = this.createPostHttpRequest();
        MuleMessage message = factory.create((Object)request, this.encoding, muleContext);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals(byte[].class, message.getPayload().getClass());
        byte[] payload = (byte[])message.getPayload();
        Assert.assertTrue((boolean)Arrays.equals("Test Message".getBytes(), payload));
    }

    private HttpRequest createPostHttpRequest() throws Exception {
        String line = REQUEST_LINE.replace("GET", "POST");
        RequestLine requestLine = RequestLine.parseLine((String)line);
        ByteArrayInputStream stream = new ByteArrayInputStream("Test Message".getBytes());
        return new HttpRequest(requestLine, HEADERS, (InputStream)stream, this.encoding);
    }

    @Test
    public void testHttpRequestMultiPartPayload() throws Exception {
        HttpMuleMessageFactory factory = (HttpMuleMessageFactory)this.createMuleMessageFactory();
        factory.setExchangePattern(MessageExchangePattern.ONE_WAY);
        HttpRequest request = this.createMultiPartHttpRequest();
        MuleMessage message = factory.create((Object)request, this.encoding, muleContext);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals(byte[].class, message.getPayload().getClass());
        byte[] payload = (byte[])message.getPayload();
        Assert.assertTrue((boolean)Arrays.equals(MULTIPART_MESSAGE.getBytes(), payload));
    }

    private HttpRequest createMultiPartHttpRequest() throws Exception {
        String line = REQUEST_LINE.replace("GET", "POST");
        RequestLine requestLine = RequestLine.parseLine((String)line);
        ByteArrayInputStream stream = new ByteArrayInputStream(MULTIPART_MESSAGE.getBytes());
        Header[] headers = new Header[]{new Header("Content-Type", "multipart/form-data; boundary=" + MULTIPART_BOUNDARY.substring(2))};
        return new HttpRequest(requestLine, headers, (InputStream)stream, this.encoding);
    }

    @Test
    public void testHttpMethodGet() throws Exception {
        ByteArrayInputStream body = new ByteArrayInputStream("/services/Echo".getBytes());
        HttpMethod method = this.createMockHttpMethod("GET", body, URI, HEADERS);
        MuleMessageFactory factory = this.createMuleMessageFactory();
        MuleMessage message = factory.create((Object)method, this.encoding, muleContext);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)"/services/Echo", (Object)message.getPayloadAsString());
        Assert.assertEquals((Object)"GET", (Object)message.getInboundProperty("http.method"));
        Assert.assertEquals((Object)HttpVersion.HTTP_1_1.toString(), (Object)message.getInboundProperty("http.version"));
        Assert.assertEquals((Object)"200", (Object)message.getInboundProperty("http.status"));
    }

    @Test
    public void testHttpMethodPost() throws Exception {
        ByteArrayInputStream body = new ByteArrayInputStream("Test Message".getBytes());
        HttpMethod method = this.createMockHttpMethod("POST", body, URI, HEADERS);
        MuleMessageFactory factory = this.createMuleMessageFactory();
        MuleMessage message = factory.create((Object)method, this.encoding, muleContext);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)"Test Message", (Object)message.getPayloadAsString());
        Assert.assertEquals((Object)"POST", (Object)message.getInboundProperty("http.method"));
        Assert.assertEquals((Object)HttpVersion.HTTP_1_1.toString(), (Object)message.getInboundProperty("http.version"));
        Assert.assertEquals((Object)"200", (Object)message.getInboundProperty("http.status"));
    }

    @Test
    public void testQueryParamProperties() throws Exception {
        ByteArrayInputStream body = new ByteArrayInputStream(REQUEST.getBytes());
        HttpMethod method = this.createMockHttpMethod("GET", body, "http://localhost/services/Echo?name=John&lastname=Galt", HEADERS);
        MuleMessageFactory factory = this.createMuleMessageFactory();
        MuleMessage message = factory.create((Object)method, this.encoding, muleContext);
        Map queryParams = (Map)message.getInboundProperty("http.query.params");
        Assert.assertNotNull((Object)queryParams);
        Assert.assertEquals((Object)"John", queryParams.get("name"));
        Assert.assertEquals((Object)"John", (Object)message.getInboundProperty("name"));
        Assert.assertEquals((Object)"Galt", queryParams.get("lastname"));
        Assert.assertEquals((Object)"Galt", (Object)message.getInboundProperty("lastname"));
        Assert.assertEquals((Object)"name=John&lastname=Galt", (Object)message.getInboundProperty("http.query.string"));
    }

    @Test
    public void testHeaderProperties() throws Exception {
        ByteArrayInputStream body = new ByteArrayInputStream(REQUEST.getBytes());
        Header[] headers = new Header[]{new Header("foo-header", "foo-value"), new Header("User-Agent", "Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.1; WOW64; Trident/5.0)"), new Header("Host", "localhost")};
        HttpMethod method = this.createMockHttpMethod("GET", body, URI, headers);
        MuleMessageFactory factory = this.createMuleMessageFactory();
        MuleMessage message = factory.create((Object)method, this.encoding, muleContext);
        Map httpHeaders = (Map)message.getInboundProperty("http.headers");
        Assert.assertNotNull((Object)headers);
        Assert.assertEquals((Object)"foo-value", httpHeaders.get("foo-header"));
        Assert.assertEquals((Object)"Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.1; WOW64; Trident/5.0)", httpHeaders.get("User-Agent"));
        Assert.assertEquals((Object)"localhost", httpHeaders.get("Host"));
        Assert.assertEquals((Object)"false", httpHeaders.get("Keep-Alive"));
        Assert.assertEquals((Object)"false", httpHeaders.get("Connection"));
        Assert.assertEquals((Object)"", (Object)message.getInboundProperty("http.query.string"));
    }

    private HttpMethod createMockHttpMethod(String method, InputStream body, String uri, Header[] headers) throws Exception {
        HttpMethod httpMethod = (HttpMethod)Mockito.mock(HttpMethod.class);
        Mockito.when((Object)httpMethod.getName()).thenReturn((Object)method);
        Mockito.when((Object)httpMethod.getStatusLine()).thenReturn((Object)new StatusLine("HTTP/1.1 200 OK"));
        Mockito.when((Object)httpMethod.getStatusCode()).thenReturn((Object)200);
        Mockito.when((Object)httpMethod.getURI()).thenReturn((Object)new URI(uri, false));
        Mockito.when((Object)httpMethod.getResponseHeaders()).thenReturn((Object)headers);
        Mockito.when((Object)httpMethod.getResponseBodyAsStream()).thenReturn((Object)body);
        return httpMethod;
    }

    @Test
    public void testMultipleHeaderWithSameName() throws Exception {
        HttpMuleMessageFactory messageFactory = new HttpMuleMessageFactory();
        Header[] headers = new Header[]{new Header("k2", "priority"), new Header("k1", "top"), new Header("k2", "always"), new Header("k2", "true")};
        Map parsedHeaders = messageFactory.convertHeadersToMap(headers, "http://localhost/");
        Assert.assertEquals((long)2L, (long)parsedHeaders.size());
        Assert.assertEquals((Object)"top", parsedHeaders.get("k1"));
        Assert.assertEquals((Object)"priority,always,true", parsedHeaders.get("k2"));
    }

    @Test
    public void testCookieHeadersCase() throws Exception {
        HttpMuleMessageFactory messageFactory = new HttpMuleMessageFactory();
        messageFactory.setEnableCookies(true);
        Header[] headers = new Header[]{new Header("SET-COOKIE", COOKIES[0]), new Header("Set-Cookie", COOKIES[1]), new Header("COOKIE", COOKIES[2]), new Header("Cookie", COOKIES[3])};
        Map parsedHeaders = messageFactory.convertHeadersToMap(headers, "http://localhost/");
        Assert.assertThat(parsedHeaders.keySet(), (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat(parsedHeaders.keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"Set-Cookie", "cookies"}));
        Cookie[] setCookies = (Cookie[])parsedHeaders.get("Set-Cookie");
        Assert.assertThat((Object)setCookies[0].toString(), (Matcher)Matchers.is((Object)COOKIES[0]));
        Assert.assertThat((Object)setCookies[1].toString(), (Matcher)Matchers.is((Object)COOKIES[1]));
        Cookie[] cookies = (Cookie[])parsedHeaders.get("cookies");
        Assert.assertThat((Object)cookies[0].toString(), (Matcher)Matchers.is((Object)COOKIES[2]));
        Assert.assertThat((Object)cookies[1].toString(), (Matcher)Matchers.is((Object)COOKIES[3]));
    }

    @Test
    public void testProcessQueryParams() throws UnsupportedEncodingException {
        HttpMuleMessageFactory messageFactory = new HttpMuleMessageFactory();
        String queryParams = "key1=value1&key2=value2&key1=value4&key3=value3&key1=value5";
        Map processedParams = messageFactory.processQueryParams("http://localhost:8080/resources?" + queryParams, "UTF-8");
        Object value1 = processedParams.get("key1");
        Assert.assertNotNull(value1);
        Assert.assertTrue((boolean)(value1 instanceof List));
        Assert.assertTrue((boolean)((List)value1).contains("value1"));
        Assert.assertTrue((boolean)((List)value1).contains("value4"));
        Assert.assertTrue((boolean)((List)value1).contains("value5"));
        Object value2 = processedParams.get("key2");
        Assert.assertNotNull(value2);
        Assert.assertEquals((Object)"value2", value2);
        Object value3 = processedParams.get("key3");
        Assert.assertNotNull(value3);
        Assert.assertEquals((Object)"value3", value3);
    }

    @Test
    public void testProcessEscapedQueryParams() throws UnsupportedEncodingException {
        HttpMuleMessageFactory messageFactory = new HttpMuleMessageFactory();
        String queryParams = "key1=value%201&key2=value2&key%203=value3&key%203=value4";
        Map processedParams = messageFactory.processQueryParams("http://localhost:8080/resources?" + queryParams, "UTF-8");
        Object value1 = processedParams.get("key1");
        Assert.assertNotNull(value1);
        Assert.assertEquals((Object)"value 1", value1);
        Object value2 = processedParams.get("key2");
        Assert.assertNotNull(value2);
        Assert.assertEquals((Object)"value2", value2);
        Object value3 = processedParams.get("key 3");
        Assert.assertNotNull(value3);
        Assert.assertTrue((boolean)(value3 instanceof List));
        Assert.assertTrue((boolean)((List)value3).contains("value3"));
        Assert.assertTrue((boolean)((List)value3).contains("value4"));
    }

    @Test
    public void testProcessWsdlQueryParam() throws UnsupportedEncodingException {
        HttpMuleMessageFactory messageFactory = new HttpMuleMessageFactory();
        Map processedParams = messageFactory.processQueryParams("http://localhost:8080/resources?wsdl", "UTF-8");
        Assert.assertTrue((boolean)processedParams.containsKey("wsdl"));
        Assert.assertNull(processedParams.get("wsdl"));
    }
}

