/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.tck.probe.Prober;

public class HttpDispatcherLifecycleTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort port = new DynamicPort("httpPort");
    private Prober prober = new PollingProber(3000L, 500L);

    protected String getConfigFile() {
        return "http-dispatcher-lifecycle-config.xml";
    }

    @Test
    public void dispatcherThreadFinishesAfterDispose() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("http://localhost:" + this.port.getValue(), (Object)"Test Message", null);
        Assert.assertThat((Object)response.getPayloadAsString(), (Matcher)CoreMatchers.equalTo((Object)"Test Message"));
        muleContext.dispose();
        this.prober.check(new Probe(){

            public boolean isSatisfied() {
                for (Thread thread : Thread.getAllStackTraces().keySet()) {
                    if (!thread.getName().startsWith("http.request.dispatch")) continue;
                    return false;
                }
                return true;
            }

            public String describeFailure() {
                return "Dispatcher thread was not stopped";
            }
        });
    }
}

