/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.api.ExceptionPayload;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.exception.AbstractMessagingExceptionStrategy;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.transport.NullPayload;

public class HttpExceptionStrategyTestCase
extends FunctionalTestCase {
    private static final int TIMEOUT = 3000;
    @Rule
    public DynamicPort port1 = new DynamicPort("port1");

    protected String getConfigFile() {
        return "http-exception-strategy-config.xml";
    }

    @Test
    public void testInExceptionDoRollbackHttpSync() throws Exception {
        String url = String.format("http://localhost:%d/flowWithoutExceptionStrategySync", this.port1.getNumber());
        MuleMessage response = muleContext.getClient().send(url, (Object)"Test Message", null, 3000L);
        Assert.assertThat((Object)response, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)response.getPayload(), (Matcher)IsNot.not((Matcher)IsInstanceOf.instanceOf(NullPayload.class)));
        Assert.assertThat((Object)response.getPayloadAsString(), (Matcher)IsNot.not((Object)"Test Message"));
        Assert.assertThat((Object)response.getExceptionPayload(), (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)response.getExceptionPayload(), (Matcher)IsInstanceOf.instanceOf(ExceptionPayload.class));
    }

    @Test
    public void testCustomStatusCodeOnExceptionWithCustomExceptionStrategy() throws Exception {
        String url = String.format("http://localhost:%d/flowWithtCESAndStatusCode", this.port1.getNumber());
        MuleMessage response = muleContext.getClient().send(url, (Object)"Test Message", null, 3000L);
        Assert.assertThat((Object)response, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)response.getInboundProperty("http.status"), (Matcher)Is.is((Object)"403"));
    }

    public static class CustomExceptionStrategy
    extends AbstractMessagingExceptionStrategy {
        public MuleEvent handleException(Exception ex, MuleEvent event) {
            event.getMessage().setOutboundProperty("http.status", (Object)"403");
            return event;
        }
    }
}

