/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.lifecycle.Callable;
import org.mule.module.http.api.HttpConstants;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class HttpHeadersTestCase
extends AbstractServiceAndFlowTestCase {
    @Rule
    public DynamicPort dynamicPort1 = new DynamicPort("port1");
    @Rule
    public DynamicPort dynamicPort2 = new DynamicPort("port2");

    public HttpHeadersTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "http-headers-config-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "http-headers-config-flow.xml"});
    }

    @Test
    public void testJettyHeaders() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send("clientEndpoint", this.getTestMuleMessage(null));
        String contentTypeProperty = (String)result.getInboundProperty("Content-Type");
        Assert.assertNotNull((Object)contentTypeProperty);
        Assert.assertEquals((Object)"application/x-download", (Object)contentTypeProperty);
        String contentDispositionProperty = (String)result.getInboundProperty("Content-Disposition");
        Assert.assertNotNull((Object)contentDispositionProperty);
        Assert.assertEquals((Object)"attachment; filename=foo.zip", (Object)contentDispositionProperty);
    }

    @Test
    public void handlesEmptyHeader() throws Exception {
        String url = String.format("http://localhost:%s", this.dynamicPort1.getNumber());
        GetMethod method = new GetMethod(url);
        method.addRequestHeader("Accept", null);
        int statusCode = new HttpClient().executeMethod((HttpMethod)method);
        Assert.assertThat((Object)statusCode, (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
        Assert.assertThat((Object)method.getResponseBodyAsString(), (Matcher)Matchers.is((Object)""));
    }

    public static class TestPayloadComponent
    implements Callable {
        public Object onCall(MuleEventContext eventContext) throws Exception {
            return eventContext.getMessage().getInboundProperty("accept");
        }
    }
}

