/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.util.ClassUtils;

public class StaticResourcesMPFunctionalTestCase
extends FunctionalTestCase {
    @ClassRule
    public static SystemProperty disablePropertiesMapping = new SystemProperty("mule.tls.disableSystemPropertiesMapping", "false");
    @ClassRule
    public static DynamicPort port1 = new DynamicPort("port1");
    @ClassRule
    public static DynamicPort port2 = new DynamicPort("port2");
    @ClassRule
    public static DynamicPort port3 = new DynamicPort("port3");
    private HttpMethod method;
    private int responseCode;
    private String payload;

    public StaticResourcesMPFunctionalTestCase() {
        System.setProperty("test.root", ClassUtils.getClassPathRoot(StaticResourcesMPFunctionalTestCase.class).getPath());
        this.setDisposeContextPerClass(true);
    }

    protected String getConfigFile() {
        return "http-static-resource-test.xml";
    }

    @Test
    public void httpUrlWithoutExplicitResourceShouldReturnDefaultDocument() throws Exception {
        String url = String.format("http://localhost:%d/static", port1.getNumber());
        this.request(url, true);
        Assert.assertEquals((long)200L, (long)this.responseCode);
        Assert.assertEquals((Object)this.payload, (Object)"Test index.html");
    }

    @Test
    public void httpUrlRequestingExplicitResourceShouldReturnResource() throws Exception {
        String url = String.format("http://localhost:%d/static/main.html", port1.getNumber());
        this.request(url, true);
        Assert.assertEquals((long)200L, (long)this.responseCode);
        Assert.assertEquals((Object)this.payload, (Object)"Test main.html");
    }

    @Test
    public void httpUrlRequestingNonexistentResourceShouldReturnNotFoundStatus() throws Exception {
        String url = String.format("http://localhost:%d/static/foo.html", port1.getNumber());
        this.request(url, true);
        Assert.assertEquals((long)404L, (long)this.responseCode);
    }

    @Test
    public void contentTypeForDefaultResourceShouldBeTextHtml() throws Exception {
        String url = String.format("http://localhost:%d/static", port1.getNumber());
        this.request(url, true);
        Assert.assertEquals((long)200L, (long)this.responseCode);
        this.assertResponseContentType("text/html");
    }

    @Test
    public void contentTypeShouldBeDetermintedFromResource() throws Exception {
        String url = String.format("http://localhost:%d/static/image.gif", port1.getNumber());
        this.request(url, true);
        Assert.assertEquals((long)200L, (long)this.responseCode);
        this.assertResponseContentType("image/gif");
    }

    @Test
    public void explicitMimeTypeConfigurationShouldOverrideDefaults() throws Exception {
        String url = String.format("http://localhost:%d/static/image.png", port1.getNumber());
        this.request(url, true);
        Assert.assertEquals((long)200L, (long)this.responseCode);
        this.assertResponseContentType("image/png");
    }

    @Test
    public void httpsUrlWithoutExplicitResourceShouldReturnDefaultDocument() throws Exception {
        String url = String.format("https://localhost:%d/static", port2.getNumber());
        this.request(url, true);
        Assert.assertEquals((long)200L, (long)this.responseCode);
        Assert.assertEquals((Object)this.payload, (Object)"Test index.html");
    }

    @Test
    public void httpsUrlRequestingExplicitResourceShouldReturnResource() throws Exception {
        String url = String.format("https://localhost:%d/static/main.html", port2.getNumber());
        this.request(url, true);
        Assert.assertEquals((long)200L, (long)this.responseCode);
        Assert.assertEquals((Object)this.payload, (Object)"Test main.html");
    }

    @Test
    public void httpsUrlRequestingNonexistentResourceShouldReturnNotFoundStatus() throws Exception {
        String url = String.format("https://localhost:%d/static/foo.html", port2.getNumber());
        this.request(url, true);
        Assert.assertEquals((long)404L, (long)this.responseCode);
    }

    private void request(String url, boolean followRedirects) throws Exception {
        this.method = new GetMethod(url);
        this.method.setFollowRedirects(followRedirects);
        this.responseCode = new HttpClient().executeMethod(this.method);
        this.payload = this.method.getResponseBodyAsString();
    }

    private void assertResponseContentType(String contentType) {
        Assert.assertEquals((Object)contentType, (Object)this.method.getResponseHeader("Content-Type").getValue());
    }

    @Test
    public void testFlowBindingOnSamePort() throws Exception {
        String url = String.format("http://localhost:%d/echo", port1.getNumber());
        this.request(url, true);
        Assert.assertEquals((long)200L, (long)this.responseCode);
        Assert.assertEquals((Object)this.method.getResponseBodyAsString(), (Object)"/echo");
        url = String.format("https://localhost:%d/echo", port2.getNumber());
        this.request(url, true);
        Assert.assertEquals((long)200L, (long)this.responseCode);
        Assert.assertEquals((Object)this.method.getResponseBodyAsString(), (Object)"/echo");
    }

    @Test
    public void httpUrlWithRootAddressShouldReturnDefaultDocument() throws Exception {
        String url = String.format("http://localhost:%d/", port3.getNumber());
        this.request(url, false);
        Assert.assertEquals((long)200L, (long)this.responseCode);
        Assert.assertEquals((Object)this.method.getResponseBodyAsString(), (Object)"Test index.html");
    }

    @Test
    public void httpUrlExplicitResourceInRootPathShouldReturnResource() throws Exception {
        String url = String.format("http://localhost:%d/index.html", port3.getNumber());
        this.request(url, false);
        Assert.assertEquals((long)200L, (long)this.responseCode);
        Assert.assertEquals((Object)this.payload, (Object)"Test index.html");
    }
}

