/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.URI;
import java.security.GeneralSecurityException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.mule.api.MuleContext;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.security.TlsDirectKeyStore;
import org.mule.api.security.TlsDirectTrustStore;
import org.mule.api.security.TlsIndirectKeyStore;
import org.mule.api.security.tls.TlsConfiguration;
import org.mule.transport.http.HttpConnector;
import org.mule.transport.ssl.SslServerSocketFactory;
import org.mule.transport.ssl.SslSocketFactory;
import org.mule.transport.tcp.AbstractTcpSocketFactory;
import org.mule.transport.tcp.SimpleServerSocketFactory;

public class HttpsConnector
extends HttpConnector
implements TlsDirectKeyStore,
TlsIndirectKeyStore,
TlsDirectTrustStore {
    public static final String HTTPS = "https";
    public static final String PEER_CERTIFICATES = "PEER_CERTIFICATES";
    public static final String LOCAL_CERTIFICATES = "LOCAL_CERTIFICATES";
    private TlsConfiguration tls = new TlsConfiguration(null);
    private long sslHandshakeTimeout = 30000L;

    public HttpsConnector(MuleContext context) {
        super(context);
        this.setSocketFactory((AbstractTcpSocketFactory)new SslSocketFactory(this.tls));
        this.setServerSocketFactory((SimpleServerSocketFactory)new SslServerSocketFactory(this.tls));
        this.setValidateConnections(false);
    }

    @Override
    protected ServerSocket getServerSocket(URI uri) throws IOException {
        SSLServerSocket serverSocket = (SSLServerSocket)super.getServerSocket(uri);
        serverSocket.setNeedClientAuth(this.isRequireClientAuthentication());
        return serverSocket;
    }

    @Override
    protected void doInitialise() throws InitialisationException {
        try {
            this.tls.initialise(null == this.getKeyStore(), "javax.net");
        }
        catch (CreateException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
        super.doInitialise();
    }

    @Override
    public String getProtocol() {
        return HTTPS;
    }

    public String getClientKeyStore() {
        return this.tls.getClientKeyStore();
    }

    public String getClientKeyStorePassword() {
        return this.tls.getClientKeyStorePassword();
    }

    public String getClientKeyStoreType() {
        return this.tls.getClientKeyStoreType();
    }

    public String getKeyManagerAlgorithm() {
        return this.tls.getKeyManagerAlgorithm();
    }

    public KeyManagerFactory getKeyManagerFactory() {
        return this.tls.getKeyManagerFactory();
    }

    public String getKeyPassword() {
        return this.tls.getKeyPassword();
    }

    public String getKeyAlias() {
        return this.tls.getKeyAlias();
    }

    public String getKeyStore() {
        return this.tls.getKeyStore();
    }

    public String getKeyStoreType() {
        return this.tls.getKeyStoreType();
    }

    public String getSslType() {
        return this.tls.getSslType();
    }

    public String getKeyStorePassword() {
        return this.tls.getKeyStorePassword();
    }

    public String getTrustManagerAlgorithm() {
        return this.tls.getTrustManagerAlgorithm();
    }

    public TrustManagerFactory getTrustManagerFactory() {
        return this.tls.getTrustManagerFactory();
    }

    public String getTrustStore() {
        return this.tls.getTrustStore();
    }

    public String getTrustStorePassword() {
        return this.tls.getTrustStorePassword();
    }

    public String getTrustStoreType() {
        return this.tls.getTrustStoreType();
    }

    public boolean isExplicitTrustStoreOnly() {
        return this.tls.isExplicitTrustStoreOnly();
    }

    public boolean isRequireClientAuthentication() {
        return this.tls.isRequireClientAuthentication();
    }

    public void setClientKeyStore(String clientKeyStore) throws IOException {
        this.tls.setClientKeyStore(clientKeyStore);
    }

    public void setClientKeyStorePassword(String clientKeyStorePassword) {
        this.tls.setClientKeyStorePassword(clientKeyStorePassword);
    }

    public void setClientKeyStoreType(String clientKeyStoreType) {
        this.tls.setClientKeyStoreType(clientKeyStoreType);
    }

    public void setExplicitTrustStoreOnly(boolean explicitTrustStoreOnly) {
        this.tls.setExplicitTrustStoreOnly(explicitTrustStoreOnly);
    }

    public void setKeyManagerAlgorithm(String keyManagerAlgorithm) {
        this.tls.setKeyManagerAlgorithm(keyManagerAlgorithm);
    }

    public void setKeyPassword(String keyPassword) {
        this.tls.setKeyPassword(keyPassword);
    }

    public void setKeyAlias(String keyAlias) {
        this.tls.setKeyAlias(keyAlias);
    }

    public void setKeyStore(String keyStore) throws IOException {
        this.tls.setKeyStore(keyStore);
    }

    public void setKeyStoreType(String keystoreType) {
        this.tls.setKeyStoreType(keystoreType);
    }

    public void setRequireClientAuthentication(boolean requireClientAuthentication) {
        this.tls.setRequireClientAuthentication(requireClientAuthentication);
    }

    public void setSslType(String sslType) {
        this.tls.setSslType(sslType);
    }

    public void setKeyStorePassword(String storePassword) {
        this.tls.setKeyStorePassword(storePassword);
    }

    public void setTrustManagerAlgorithm(String trustManagerAlgorithm) {
        this.tls.setTrustManagerAlgorithm(trustManagerAlgorithm);
    }

    public void setTrustManagerFactory(TrustManagerFactory trustManagerFactory) {
        this.tls.setTrustManagerFactory(trustManagerFactory);
    }

    public void setTrustStore(String trustStore) throws IOException {
        this.tls.setTrustStore(trustStore);
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.tls.setTrustStorePassword(trustStorePassword);
    }

    public void setTrustStoreType(String trustStoreType) {
        this.tls.setTrustStoreType(trustStoreType);
    }

    public long getSslHandshakeTimeout() {
        return this.sslHandshakeTimeout;
    }

    public void setSslHandshakeTimeout(long sslHandshakeTimeout) {
        this.sslHandshakeTimeout = sslHandshakeTimeout;
    }

    public SSLSocketFactory getSslSocketFactory() throws GeneralSecurityException {
        return this.tls.getSocketFactory();
    }
}

