/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import org.apache.commons.httpclient.Header;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.CustomTimeZone;
import org.mule.transport.http.HttpResponse;

public abstract class AbstractDateHeaderTestCase
extends AbstractMuleTestCase {
    @Rule
    public final CustomTimeZone timeZone = new CustomTimeZone("EST");

    @Test
    public void testDateHeaderFormat() throws Exception {
        this.initialise();
        HttpResponse response = new HttpResponse();
        DateTime dateTime = new DateTime(2005, 9, 5, 16, 30, 0, 0, DateTimeZone.forID((String)"EST"));
        this.setDateHeader(response, dateTime.getMillis());
        boolean headerFound = false;
        for (Header header : response.getHeaders()) {
            if (!"Date".equals(header.getName())) continue;
            headerFound = true;
            Assert.assertThat((Object)header.getValue(), (Matcher)CoreMatchers.equalTo((Object)this.getExpectedHeaderValue()));
        }
        Assert.assertThat((String)"Date header missing.", (Object)headerFound, (Matcher)CoreMatchers.equalTo((Object)true));
    }

    protected abstract void initialise() throws Exception;

    protected abstract void setDateHeader(HttpResponse var1, long var2);

    protected abstract String getExpectedHeaderValue();
}

