/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.endpoint.MuleEndpointURI;
import org.mule.security.MuleCredentials;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.transport.http.HttpConnector;

@RunWith(value=MockitoJUnitRunner.class)
public class HttpConnectorClientAuthorizationTestCase
extends AbstractMuleContextTestCase {
    private static final String CREDENTIALS_USER = "myUser";
    private static final String CREDENTIALS_PASSWORD = "myPassword";
    private static final String URI_WITHOUT_CREDENTIALS = "http://localhost:60127";
    private static final String URI_WITH_CREDENTIALS = "http://myUser:myPassword@localhost:60127";
    private static final String HEADER_AUTHORIZATION_VALUE = "headerAuthValue";
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MuleEvent mockMuleEvent;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private HttpClient mockHttpClient;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private HttpMethod mockHttpMethod;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ImmutableEndpoint mockImmutableEndpoint;
    private URI uri;
    private MuleMessage message;
    private String encoding;
    private HttpConnector connector;

    @Before
    public void setup() throws URISyntaxException {
        this.uri = new URI(URI_WITHOUT_CREDENTIALS);
        this.message = new DefaultMuleMessage((Object)"", muleContext);
        this.encoding = muleContext.getConfiguration().getDefaultEncoding();
        this.connector = new HttpConnector(muleContext);
        this.connector.setName("test");
    }

    @Test
    public void testWithCredentials() throws Exception {
        MuleCredentials credentials = new MuleCredentials(CREDENTIALS_USER, CREDENTIALS_PASSWORD.toCharArray());
        Mockito.when((Object)this.mockMuleEvent.getCredentials()).thenReturn((Object)credentials);
        Mockito.when((Object)this.mockMuleEvent.getMessageSourceURI()).thenReturn((Object)this.uri);
        Mockito.when((Object)this.mockMuleEvent.getMessage()).thenReturn((Object)this.message);
        this.connector.setupClientAuthorization(this.mockMuleEvent, this.mockHttpMethod, this.mockHttpClient, this.mockImmutableEndpoint);
        ((HttpState)Mockito.verify((Object)this.mockHttpClient.getState(), (VerificationMode)Mockito.atLeast((int)1))).setCredentials((AuthScope)Matchers.isA(AuthScope.class), (Credentials)Matchers.isA(Credentials.class));
    }

    @Test
    public void testWithUserInfo() throws Exception {
        URI uri = new URI(URI_WITH_CREDENTIALS);
        Mockito.when((Object)this.mockMuleEvent.getMessageSourceURI()).thenReturn((Object)uri);
        Mockito.when((Object)this.mockMuleEvent.getMessage()).thenReturn((Object)this.message);
        Mockito.when((Object)this.mockMuleEvent.getCredentials()).thenReturn(null);
        Mockito.when((Object)this.mockImmutableEndpoint.getProperty((Object)"Authorization")).thenReturn(null);
        Mockito.when((Object)this.mockImmutableEndpoint.getEncoding()).thenReturn((Object)this.encoding);
        Mockito.when((Object)this.mockImmutableEndpoint.getEndpointURI()).thenReturn((Object)new MuleEndpointURI(URI_WITH_CREDENTIALS, muleContext));
        this.connector.setupClientAuthorization(this.mockMuleEvent, this.mockHttpMethod, this.mockHttpClient, this.mockImmutableEndpoint);
        ((HttpMethod)Mockito.verify((Object)this.mockHttpMethod, (VerificationMode)Mockito.atLeast((int)1))).addRequestHeader((String)Matchers.eq((Object)"Authorization"), Matchers.anyString());
    }

    @Test
    public void testWithCredentialsAndUserInfo() throws Exception {
        MuleCredentials credentials = new MuleCredentials(CREDENTIALS_USER, CREDENTIALS_PASSWORD.toCharArray());
        URI uri = new URI(URI_WITH_CREDENTIALS);
        Mockito.when((Object)this.mockMuleEvent.getCredentials()).thenReturn((Object)credentials);
        Mockito.when((Object)this.mockMuleEvent.getMessageSourceURI()).thenReturn((Object)uri);
        Mockito.when((Object)this.mockMuleEvent.getMessage()).thenReturn((Object)this.message);
        Mockito.when((Object)this.mockImmutableEndpoint.getProperty((Object)"Authorization")).thenReturn(null);
        Mockito.when((Object)this.mockImmutableEndpoint.getEncoding()).thenReturn((Object)this.encoding);
        Mockito.when((Object)this.mockImmutableEndpoint.getEndpointURI()).thenReturn((Object)new MuleEndpointURI(URI_WITH_CREDENTIALS, muleContext));
        this.connector.setupClientAuthorization(this.mockMuleEvent, this.mockHttpMethod, this.mockHttpClient, this.mockImmutableEndpoint);
        ((HttpMethod)Mockito.verify((Object)this.mockHttpMethod, (VerificationMode)Mockito.atLeast((int)1))).addRequestHeader((String)Matchers.eq((Object)"Authorization"), Matchers.anyString());
        ((HttpState)Mockito.verify((Object)this.mockHttpClient.getState(), (VerificationMode)Mockito.never())).setCredentials((AuthScope)Matchers.isA(AuthScope.class), (Credentials)Matchers.isA(Credentials.class));
    }

    @Test
    public void testWithAuthorizationHeader() throws Exception {
        this.message.setOutboundProperty("Authorization", (Object)HEADER_AUTHORIZATION_VALUE);
        Mockito.when((Object)this.mockMuleEvent.getMessageSourceURI()).thenReturn((Object)this.uri);
        Mockito.when((Object)this.mockMuleEvent.getMessage()).thenReturn((Object)this.message);
        Mockito.when((Object)this.mockMuleEvent.getCredentials()).thenReturn(null);
        Mockito.when((Object)this.mockImmutableEndpoint.getProperty((Object)"Authorization")).thenReturn((Object)HEADER_AUTHORIZATION_VALUE);
        Mockito.when((Object)this.mockHttpMethod.getRequestHeader("Authorization")).thenReturn(null);
        this.connector.setupClientAuthorization(this.mockMuleEvent, this.mockHttpMethod, this.mockHttpClient, this.mockImmutableEndpoint);
        ((HttpMethod)Mockito.verify((Object)this.mockHttpMethod, (VerificationMode)Mockito.atLeast((int)1))).addRequestHeader((String)Matchers.eq((Object)"Authorization"), Matchers.anyString());
    }

    @Test
    public void testWithProxyAuth() throws Exception {
        Mockito.when((Object)this.mockMuleEvent.getMessageSourceURI()).thenReturn((Object)this.uri);
        Mockito.when((Object)this.mockMuleEvent.getMessage()).thenReturn((Object)this.message);
        Mockito.when((Object)this.mockMuleEvent.getCredentials()).thenReturn(null);
        this.connector.setProxyUsername(CREDENTIALS_USER);
        this.connector.setProxyPassword(CREDENTIALS_PASSWORD);
        this.connector.setupClientAuthorization(this.mockMuleEvent, this.mockHttpMethod, this.mockHttpClient, this.mockImmutableEndpoint);
        ((HttpClientParams)Mockito.verify((Object)this.mockHttpClient.getParams(), (VerificationMode)Mockito.never())).setAuthenticationPreemptive(false);
    }

    @Test
    public void testClean() throws Exception {
        Mockito.when((Object)this.mockMuleEvent.getMessageSourceURI()).thenReturn((Object)this.uri);
        Mockito.when((Object)this.mockMuleEvent.getMessage()).thenReturn((Object)this.message);
        Mockito.when((Object)this.mockMuleEvent.getCredentials()).thenReturn(null);
        this.connector.setProxyUsername(null);
        this.connector.setProxyPassword(null);
        this.connector.setupClientAuthorization(this.mockMuleEvent, this.mockHttpMethod, this.mockHttpClient, this.mockImmutableEndpoint);
        ((HttpClientParams)Mockito.verify((Object)this.mockHttpClient.getParams(), (VerificationMode)Mockito.atLeast((int)1))).setAuthenticationPreemptive(false);
    }
}

