/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import java.nio.charset.StandardCharsets;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class HttpOutboundDataTypeTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort httpPort = new DynamicPort("httpPort");

    protected String getConfigFile() {
        return "http-datatype-config.xml";
    }

    @Test
    public void propagatesDataType() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        DefaultMuleMessage muleMessage = new DefaultMuleMessage((Object)"Test Message", muleContext);
        muleMessage.setOutboundProperty("Content-Type", (Object)("text/plain; charset=" + StandardCharsets.UTF_16.name()));
        client.dispatch("vm://testInput", (MuleMessage)muleMessage);
        MuleMessage response = client.request("vm://testOutput", 120000L);
        MatcherAssert.assertThat((Object)response.getDataType().getMimeType(), (Matcher)Matchers.equalTo((Object)"text/plain"));
        MatcherAssert.assertThat((Object)response.getDataType().getEncoding(), (Matcher)Matchers.equalTo((Object)StandardCharsets.UTF_16.name()));
        MatcherAssert.assertThat((Object)response.getOutboundProperty("MULE_ENCODING"), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)response.getOutboundProperty("Content-Type"), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }
}

