/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.httpclient.Header;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleException;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.tck.probe.Prober;
import org.mule.transport.http.HttpRequest;
import org.mule.transport.http.functional.AbstractMockHttpServerTestCase;
import org.mule.transport.http.functional.MockHttpServer;

public class HttpOutboundKeepAliveTestCase
extends AbstractMockHttpServerTestCase {
    private static final String KEEP_ALIVE_ONE_WAY_PATH = "vm://keepAliveOneWay";
    private static final String KEEP_ALIVE_REQUEST_RESPONSE_PATH = "vm://keepAliveRequestResponse";
    private static final String NO_KEEP_ALIVE_ONE_WAY_PATH = "vm://noKeepAliveOneWay";
    private static final String NO_KEEP_ALIVE_REQUEST_RESPONSE_PATH = "vm://noKeepAliveRequestResponse";
    private static final String DEFAULT_KEEP_ALIVE_ONE_WAY_PATH = "vm://defaultKeepAliveOneWay";
    private static final String DEFAULT_KEEP_ALIVE_REQUEST_RESPONSE_PATH = "vm://defaultKeepAliveRequestResponse";
    private static final String CONNECTION_CLOSE_VALUE = "close";
    @Rule
    public DynamicPort httpPort = new DynamicPort("httpPort");
    private volatile String connectionHeader;
    private volatile int requestCount;
    private Prober prober = new PollingProber(2000L, 100L);

    public HttpOutboundKeepAliveTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList(new Object[][]{{AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "http-outbound-keep-alive.xml"}});
    }

    @Override
    protected MockHttpServer getHttpServer() {
        return new KeepAliveHTTPServer(this.httpPort.getNumber());
    }

    @Test
    public void closesConnectionWhenOneWayEndpointHasNoKeepAlive() throws MuleException {
        this.assertConnectionClosed(NO_KEEP_ALIVE_ONE_WAY_PATH);
    }

    @Test
    public void closesConnectionWhenRequestResponseEndpointHasNoKeepAlive() throws MuleException {
        this.assertConnectionClosed(NO_KEEP_ALIVE_ONE_WAY_PATH);
    }

    @Test
    public void reusesConnectionWhenOneWayEndpointHasKeepAlive() throws MuleException {
        this.assertKeepAlive(KEEP_ALIVE_ONE_WAY_PATH);
    }

    @Test
    @Ignore(value="MULE-6926: Flaky test")
    public void reusesConnectionWhenRequestResponseEndpointHasKeepAlive() throws MuleException {
        this.assertKeepAlive(KEEP_ALIVE_REQUEST_RESPONSE_PATH);
    }

    @Test
    public void reusesConnectionWhenOneWayEndpointHasDefaultKeepAlive() throws MuleException {
        this.assertKeepAlive(DEFAULT_KEEP_ALIVE_ONE_WAY_PATH);
    }

    @Test
    public void reusesConnectionWhenRequestResponseEndpointHasDefaultKeepAlive() throws MuleException {
        this.assertKeepAlive(DEFAULT_KEEP_ALIVE_REQUEST_RESPONSE_PATH);
    }

    private void assertKeepAlive(String endpoint) throws MuleException {
        muleContext.getClient().dispatch(endpoint, (Object)"Test Message", null);
        this.assertRequestCount(1);
        muleContext.getClient().dispatch(endpoint, (Object)"Test Message", null);
        this.assertRequestCount(2);
    }

    private void assertConnectionClosed(String endpoint) throws MuleException {
        muleContext.getClient().dispatch(NO_KEEP_ALIVE_REQUEST_RESPONSE_PATH, (Object)"Test Message", null);
        this.assertRequestCount(1);
        Assert.assertEquals((Object)CONNECTION_CLOSE_VALUE, (Object)this.connectionHeader);
    }

    private void assertRequestCount(final int expectedRequestCount) {
        this.prober.check(new Probe(){

            public boolean isSatisfied() {
                return HttpOutboundKeepAliveTestCase.this.requestCount == expectedRequestCount;
            }

            public String describeFailure() {
                return String.format("Expected %d requests but received %d.", expectedRequestCount, HttpOutboundKeepAliveTestCase.this.requestCount);
            }
        });
    }

    private class KeepAliveHTTPServer
    extends MockHttpServer {
        private static final int MAX_REQUESTS = 2;

        public KeepAliveHTTPServer(int port) {
            super(port);
        }

        @Override
        protected void processRequests(InputStream in, OutputStream out) throws IOException {
            boolean closeConnection = false;
            while (HttpOutboundKeepAliveTestCase.this.requestCount < 2 && !closeConnection) {
                HttpRequest request = this.parseRequest(in, muleContext.getConfiguration().getDefaultEncoding());
                Header connHeader = request.getFirstHeader("Connection");
                HttpOutboundKeepAliveTestCase.this.connectionHeader = connHeader == null ? null : connHeader.getValue();
                HttpOutboundKeepAliveTestCase.this.requestCount++;
                closeConnection = HttpOutboundKeepAliveTestCase.CONNECTION_CLOSE_VALUE.equals(HttpOutboundKeepAliveTestCase.this.connectionHeader);
                StringBuilder response = new StringBuilder("HTTP/1.1 200 OK\n");
                if (closeConnection) {
                    response.append(String.format("%s: %s\n", "Connection", HttpOutboundKeepAliveTestCase.CONNECTION_CLOSE_VALUE));
                }
                response.append("Content-Length: 4\n\nTEST");
                out.write(response.toString().getBytes());
            }
        }
    }
}

