/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import java.io.IOException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class HttpRootLevelRequestsTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort httpPort1 = new DynamicPort("port1");
    @Rule
    public DynamicPort httpPort2 = new DynamicPort("port2");
    @Rule
    public DynamicPort httpPort3 = new DynamicPort("port3");
    @Rule
    public DynamicPort httpPort4 = new DynamicPort("port4");
    @Rule
    public DynamicPort httpPort5 = new DynamicPort("port5");

    protected String getConfigFile() {
        return "http-root-level-requests.xml";
    }

    @Test
    public void acceptsRootRequestsInHttpEndpointWithoutPath() throws IOException {
        this.assertRootResponseOk(this.httpPort1.getValue());
    }

    @Test
    public void acceptsRootRequestsInHttpEndpointWithEmptyPath() throws IOException {
        this.assertRootResponseOk(this.httpPort2.getValue());
    }

    @Test
    public void acceptsRootRequestsInHttpEndpointWithRootPath() throws IOException {
        this.assertRootResponseOk(this.httpPort3.getValue());
    }

    @Test
    public void acceptsRootRequestsInHttpAddressWithoutTrailingSlash() throws IOException {
        this.assertRootResponseOk(this.httpPort4.getValue());
    }

    @Test
    public void acceptsRootRequestsInHttpAddressWithTrailingSlash() throws IOException {
        this.assertRootResponseOk(this.httpPort5.getValue());
    }

    private void assertRootResponseOk(String port) throws IOException {
        String url = "http://localhost:" + port;
        this.assertResponseOk(url);
        this.assertResponseOk(url + "/");
    }

    private void assertResponseOk(String url) throws IOException {
        HttpClient client = new HttpClient();
        GetMethod getMethod = new GetMethod(url);
        int statusCode = client.executeMethod((HttpMethod)getMethod);
        Assert.assertEquals((long)200L, (long)statusCode);
    }
}

