/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.api.MuleEvent;
import org.mule.construct.Flow;
import org.mule.module.http.api.HttpConstants;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

@RunWith(value=Parameterized.class)
public class HttpUndefinedMethodsBodyTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort port = new DynamicPort("port");
    @Parameterized.Parameter(value=0)
    public String method;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({HttpConstants.Methods.GET.name()}, {HttpConstants.Methods.DELETE.name()});
    }

    protected String getConfigFile() {
        return "http-undefined-methods-body-config.xml";
    }

    @Test
    public void sendBody() throws Exception {
        this.sendRequestAndAssertMethod("test", "test");
    }

    @Test
    public void noBody() throws Exception {
        this.sendRequestAndAssertMethod(null, "/");
    }

    private void sendRequestAndAssertMethod(String payload, String expectedContent) throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("requestFlow");
        MuleEvent event = HttpUndefinedMethodsBodyTestCase.getTestEvent((Object)payload);
        event.setFlowVariable("method", (Object)this.method);
        event = flow.process(event);
        Assert.assertThat((Object)event.getMessage().getInboundProperty("http.status"), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
        Assert.assertThat((Object)event.getMessageAsString(), (Matcher)Matchers.is((Object)expectedContent));
    }
}

