/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.servlet;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.TimeZone;
import javax.servlet.ServletInputStream;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.io.IOUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.EndpointException;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.registry.MuleRegistry;
import org.mule.api.transaction.TransactionConfig;
import org.mule.endpoint.MuleEndpointURI;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.transport.http.servlet.MuleHttpServletRequest;
import org.mule.transport.http.servlet.MuleHttpServletResponse;

public class MuleServletTestCase
extends AbstractMuleTestCase {
    private TimeZone savedTimeZone;
    private MuleContext muleContext;
    private MuleRegistry registry;

    @Before
    public void setUp() {
        this.savedTimeZone = TimeZone.getDefault();
        TimeZone.setDefault(TimeZone.getTimeZone("America/Los_Angeles"));
        this.muleContext = (MuleContext)Mockito.mock(MuleContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        this.registry = (MuleRegistry)Mockito.mock(MuleRegistry.class);
        Mockito.when((Object)this.muleContext.getRegistry()).thenReturn((Object)this.registry);
    }

    @After
    public void tearDown() {
        TimeZone.setDefault(this.savedTimeZone);
    }

    @Test
    public void testHttpServletRequest() throws Exception {
        String queryParam = "array=1&array=2&param1=param1&noValueParam";
        DefaultMuleEvent event = this.getTestHttpEvent(queryParam);
        MuleHttpServletRequest request = new MuleHttpServletRequest((MuleEvent)event);
        ServletInputStream stream = request.getInputStream();
        Assert.assertNotNull((Object)stream);
        IOUtils.contentEquals((InputStream)new ByteArrayInputStream("test".getBytes()), (InputStream)stream);
        Assert.assertEquals((Object)"value", (Object)request.getHeader("X-MyHeader"));
        Assert.assertEquals((Object)"UTF-8", (Object)request.getCharacterEncoding());
        Assert.assertEquals((long)-1L, (long)request.getContentLength());
        Assert.assertEquals((Object)"text/plain", (Object)request.getContentType());
        Assert.assertEquals((Object)"/foo", (Object)request.getContextPath());
        Assert.assertEquals((Object)"GET", (Object)request.getMethod());
        Assert.assertEquals((Object)"/bar", (Object)request.getPathInfo());
        Assert.assertEquals((Object)queryParam, (Object)request.getQueryString());
        Assert.assertEquals((Object)"/foo/bar", (Object)request.getRequestURI());
        Assert.assertEquals((Object)"/foo", (Object)request.getServletPath());
        Assert.assertEquals((Object)"127.0.0.1", (Object)request.getServerName());
    }

    @Test
    public void testNoQueryParams() throws Exception {
        DefaultMuleEvent event = this.getTestHttpEvent("");
        MuleHttpServletRequest request = new MuleHttpServletRequest((MuleEvent)event);
        Assert.assertEquals((Object)"", (Object)request.getQueryString());
    }

    @Test
    public void testResponse() throws Exception {
        DefaultMuleEvent event = this.getTestHttpEvent("");
        MuleMessage message = event.getMessage();
        MuleHttpServletResponse response = new MuleHttpServletResponse((MuleEvent)event);
        response.setStatus(404);
        Assert.assertEquals((Object)404, (Object)message.getOutboundProperty("http.status"));
        response.setStatus(200, "status message");
        Assert.assertEquals((Object)200, (Object)message.getOutboundProperty("http.status"));
        response.setContentType("application/octet-stream");
        Assert.assertEquals((Object)"application/octet-stream", (Object)message.getOutboundProperty("Content-Type"));
        Assert.assertEquals((Object)"application/octet-stream", (Object)response.getContentType());
        response.setHeader("X-Test", "value");
        Assert.assertTrue((boolean)response.containsHeader("X-Test"));
        Assert.assertEquals((Object)"value", (Object)message.getOutboundProperty("X-Test"));
        response.setDateHeader("X-Date", 0L);
        Assert.assertEquals((Object)"Wed, 31 Dec 1969 00:00:00 GMT", (Object)message.getOutboundProperty("X-Date"));
        response.sendRedirect("http://anotherplace");
        Assert.assertEquals((Object)"http://anotherplace", (Object)message.getOutboundProperty("Location"));
        Assert.assertEquals((Object)302, (Object)message.getOutboundProperty("http.status"));
    }

    @Test
    public void testCookies() throws Exception {
        DefaultMuleEvent event = this.getTestHttpEvent("");
        MuleMessage message = event.getMessage();
        MuleHttpServletResponse response = new MuleHttpServletResponse((MuleEvent)event);
        response.addCookie(new javax.servlet.http.Cookie("cookie1", "value"));
        Cookie[] cookies = (Cookie[])message.getOutboundProperty("cookies");
        Assert.assertNotNull((Object)cookies);
        Cookie cookie = cookies[0];
        Assert.assertEquals((Object)"cookie1", (Object)cookie.getName());
        Assert.assertEquals((Object)"value", (Object)cookie.getValue());
        response.addCookie(new javax.servlet.http.Cookie("cookie2", "value"));
        cookies = (Cookie[])message.getOutboundProperty("cookies");
        Assert.assertNotNull((Object)cookies);
        Assert.assertEquals((long)2L, (long)cookies.length);
        cookie = cookies[1];
        Assert.assertEquals((Object)"cookie2", (Object)cookie.getName());
        Assert.assertEquals((Object)"value", (Object)cookie.getValue());
    }

    private DefaultMuleEvent getTestHttpEvent(String queryParam) throws EndpointException {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"payload", this.muleContext);
        message.setInboundProperty("X-MyHeader", (Object)"value");
        message.setInboundProperty("Content-Type", (Object)"text/plain");
        message.setInboundProperty("http.method", (Object)"GET");
        message.setInboundProperty("http.context.path", (Object)"/foo");
        message.setInboundProperty("http.request.path", (Object)"/foo/bar");
        if (queryParam != null) {
            queryParam = "?" + queryParam;
        }
        message.setInboundProperty("http.request", (Object)("/foo/bar" + queryParam));
        message.setInboundProperty("Host", (Object)"127.0.0.1");
        message.setEncoding("UTF-8");
        InboundEndpoint ep = (InboundEndpoint)Mockito.mock(InboundEndpoint.class);
        Mockito.when((Object)ep.getAddress()).thenReturn((Object)"http://localhost:8080/foo");
        Mockito.when((Object)ep.getName()).thenReturn((Object)"test");
        Mockito.when((Object)ep.getEndpointURI()).thenReturn((Object)new MuleEndpointURI("http://localhost:8080/foo", this.muleContext));
        TransactionConfig txConfig = (TransactionConfig)Mockito.mock(TransactionConfig.class);
        Mockito.when((Object)ep.getTransactionConfig()).thenReturn((Object)txConfig);
        Mockito.when((Object)ep.getExchangePattern()).thenReturn((Object)MessageExchangePattern.REQUEST_RESPONSE);
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)message, ep, (FlowConstruct)null);
        return event;
    }
}

