/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jbi;

import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import org.mule.impl.MuleMessage;
import org.mule.providers.AbstractMessageDispatcher;
import org.mule.providers.jbi.JbiConnector;
import org.mule.providers.jbi.JbiUtils;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOImmutableEndpoint;

public class JbiMessageDispatcher
extends AbstractMessageDispatcher {
    private JbiConnector connector;

    public JbiMessageDispatcher(UMOImmutableEndpoint endpoint) {
        super(endpoint);
        this.connector = (JbiConnector)endpoint.getConnector();
    }

    protected void doDispose() {
    }

    protected void doDispatch(UMOEvent event) throws Exception {
        InOnly exchange = this.connector.getExchangeFactory().createInOnlyExchange();
        NormalizedMessage message = exchange.createMessage();
        exchange.setInMessage(message);
        JbiUtils.populateNormalizedMessage(event.getMessage(), message);
        this.done((MessageExchange)exchange);
    }

    protected UMOMessage doSend(UMOEvent event) throws Exception {
        InOut exchange = this.connector.getExchangeFactory().createInOutExchange();
        NormalizedMessage message = exchange.createMessage();
        exchange.setInMessage(message);
        JbiUtils.populateNormalizedMessage(event.getMessage(), message);
        NormalizedMessage nm = exchange.getOutMessage();
        MuleMessage response = null;
        if (nm != null) {
            response = new MuleMessage((Object)this.connector.getMessageAdapter(nm));
        }
        this.done((MessageExchange)exchange);
        return response;
    }

    protected UMOMessage doReceive(UMOImmutableEndpoint endpoint, long timeout) throws Exception {
        throw new UnsupportedOperationException("doReceive");
    }

    public Object getDelegateSession() throws UMOException {
        return null;
    }

    protected void error(MessageExchange me, Fault fault) throws MessagingException {
        me.setFault(fault);
        me.setStatus(ExchangeStatus.ERROR);
        this.connector.getDeliveryChannel().send(me);
    }

    protected void done(MessageExchange me) throws MessagingException {
        me.setStatus(ExchangeStatus.DONE);
        this.connector.getDeliveryChannel().send(me);
    }

    protected void doConnect(UMOImmutableEndpoint endpoint) throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }
}

