/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jbi;

import java.io.ByteArrayInputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.mule.impl.MuleMessage;
import org.mule.umo.UMOMessage;

public class JbiUtils {
    public static UMOMessage createMessage(NormalizedMessage message) throws MessagingException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        Iterator iterator = message.getPropertyNames().iterator();
        while (iterator.hasNext()) {
            String s = (String)iterator.next();
            properties.put(s, message.getProperty(s));
        }
        if (message.getSecuritySubject() != null) {
            properties.put("MULE_USER", message.getSecuritySubject());
        }
        try {
            Source source = message.getContent();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            StreamResult result = new StreamResult((OutputStream)baos);
            TransformerFactory.newInstance().newTransformer().transform(source, result);
            MuleMessage msg = new MuleMessage((Object)baos.toByteArray(), properties);
            baos.close();
            return msg;
        }
        catch (Exception e) {
            throw new MessagingException(e.getMessage(), (Throwable)e);
        }
    }

    public static void populateNormalizedMessage(UMOMessage muleMessage, NormalizedMessage message) throws MessagingException {
        String s;
        try {
            message.setContent((Source)new StreamSource(new ByteArrayInputStream(muleMessage.getPayloadAsBytes())));
        }
        catch (Exception e) {
            throw new MessagingException(e.getMessage(), (Throwable)e);
        }
        Iterator iterator = muleMessage.getPropertyNames().iterator();
        while (iterator.hasNext()) {
            s = (String)iterator.next();
            message.setProperty(s, muleMessage.getProperty(s));
        }
        iterator = muleMessage.getAttachmentNames().iterator();
        while (iterator.hasNext()) {
            s = (String)iterator.next();
            message.addAttachment(s, muleMessage.getAttachment(s));
        }
    }
}

