/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jbi.components;

import java.util.HashMap;
import java.util.Map;
import javax.jbi.JBIException;
import javax.jbi.component.Component;
import javax.jbi.component.ComponentContext;
import javax.jbi.component.ComponentLifeCycle;
import javax.jbi.component.ServiceUnitManager;
import javax.jbi.management.DeploymentException;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkManager;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.config.converters.QNameConverter;
import org.mule.providers.jbi.components.MessageExchangeListener;
import org.mule.util.concurrent.WaitableBoolean;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;

public abstract class AbstractJbiComponent
implements Component,
Work,
ComponentLifeCycle {
    public static final String IN = "in";
    public static final String OUT = "out";
    protected transient Log logger = LogFactory.getLog(this.getClass());
    protected ComponentContext context;
    protected Map serviceDescriptions = new HashMap();
    protected QName service;
    protected String name;
    protected WorkManager workManager;
    protected DeliveryChannel deliveryChannel;
    protected ObjectName mbeanName;
    protected ServiceUnitManager serviceUnitManager;
    protected MessageExchangeFactory exchangeFactory;
    protected WaitableBoolean started = new WaitableBoolean(false);

    public ComponentLifeCycle getLifeCycle() {
        return this;
    }

    public ServiceUnitManager getServiceUnitManager() {
        return this.serviceUnitManager;
    }

    public Document getServiceDescription(ServiceEndpoint endpoint) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Querying service description for " + endpoint));
        }
        String key = this.getKey(endpoint);
        Document doc = (Document)this.serviceDescriptions.get(key);
        if (this.logger.isDebugEnabled()) {
            if (doc != null) {
                this.logger.debug((Object)"Description found");
            } else {
                this.logger.debug((Object)"Description not found");
            }
        }
        return doc;
    }

    public void setServiceDescription(ServiceEndpoint endpoint, Document doc) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Setting service description for " + endpoint));
        }
        String key = this.getKey(endpoint);
        this.serviceDescriptions.put(key, doc);
    }

    private String getKey(ServiceEndpoint endpoint) {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        sb.append(endpoint.getServiceName().getNamespaceURI());
        sb.append("}");
        sb.append(endpoint.getServiceName().getLocalPart());
        sb.append(":");
        sb.append(endpoint.getEndpointName());
        return sb.toString();
    }

    public boolean isExchangeWithConsumerOkay(ServiceEndpoint endpoint, MessageExchange exchange) {
        return true;
    }

    public boolean isExchangeWithProviderOkay(ServiceEndpoint endpoint, MessageExchange exchange) {
        return true;
    }

    public ServiceEndpoint resolveEndpointReference(DocumentFragment epr) {
        return null;
    }

    protected ObjectName createExtensionMBeanName() throws Exception {
        return this.context.getMBeanNames().createCustomComponentMBeanName("extension");
    }

    public Object getExtensionMBean() {
        return null;
    }

    public QName getService() {
        return this.service;
    }

    public void setService(QName service) {
        this.service = service;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public WorkManager getWorkManager() {
        return this.workManager;
    }

    public void setWorkManager(WorkManager workManager) {
        this.workManager = workManager;
    }

    public final synchronized void init(ComponentContext context) throws JBIException {
        try {
            if (context.getComponentName() != null) {
                this.name = context.getComponentName();
            }
            if (this.name == null) {
                throw new NullPointerException("No name has been set for this component");
            }
            if (this.service == null) {
                this.service = (QName)new QNameConverter().convert(QName.class, (Object)this.name);
            }
            context.activateEndpoint(this.service, this.service.getLocalPart());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Initializing component: " + this.name));
            }
            this.context = context;
            this.deliveryChannel = context.getDeliveryChannel();
            this.exchangeFactory = this.deliveryChannel.createExchangeFactory();
            Object mbean = this.getExtensionMBean();
            if (this.serviceUnitManager == null) {
                this.serviceUnitManager = new DefaultServiceUnitManager();
            }
            if (this.workManager == null) {
                this.workManager = MuleManager.getInstance().getWorkManager();
            }
            if (mbean != null) {
                MBeanServer server;
                if (this.mbeanName == null) {
                    this.mbeanName = this.createExtensionMBeanName();
                }
                if ((server = this.context.getMBeanServer()) == null) {
                    throw new JBIException("null mBeanServer");
                }
                if (server.isRegistered(this.mbeanName)) {
                    server.unregisterMBean(this.mbeanName);
                }
                server.registerMBean(mbean, this.mbeanName);
            }
            this.doInit();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Jbi Receiver Component initialized: " + this.name));
            }
        }
        catch (JBIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JBIException("Error calling init on " + this.name, (Throwable)e);
        }
    }

    public final void shutDown() throws JBIException {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Shutting down component: " + this.getName()));
            }
            this.started.set(false);
            this.doShutdown();
            if (this.mbeanName != null) {
                MBeanServer server = this.context.getMBeanServer();
                if (server == null) {
                    throw new JBIException("null mBeanServer");
                }
                if (server.isRegistered(this.mbeanName)) {
                    server.unregisterMBean(this.mbeanName);
                }
            }
            this.context = null;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Component shut down: " + this.getName()));
            }
        }
        catch (JBIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JBIException("Error calling shutdown on " + this.getName(), (Throwable)e);
        }
    }

    public final void start() throws JBIException {
        this.logger.debug((Object)("Starting Mule Jbi component: " + this.name));
        this.started.set(true);
        if (this instanceof MessageExchangeListener) {
            try {
                this.logger.debug((Object)("Starting ME thread for: " + this.name));
                this.getWorkManager().scheduleWork((Work)this);
            }
            catch (WorkException e) {
                throw new JBIException((Throwable)e);
            }
        }
        this.doStart();
    }

    public final void stop() throws JBIException {
        this.started.set(false);
        this.doStop();
    }

    protected void doInit() throws JBIException {
    }

    protected void doStart() throws JBIException {
    }

    protected void doStop() throws JBIException {
    }

    protected void doShutdown() throws JBIException {
    }

    public ObjectName getExtensionMBeanName() {
        return this.mbeanName;
    }

    public void setExtensionMBeanName(ObjectName mbeanName) {
        this.mbeanName = mbeanName;
    }

    public void release() {
    }

    public void run() {
        while (this.started.get()) {
            try {
                MessageExchange me = this.deliveryChannel.accept();
                if (me == null) continue;
                this.getWorkManager().scheduleWork((Work)new MessageExchangeWorker(me, (MessageExchangeListener)((Object)this)));
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void handleException(Throwable t) {
        this.logger.error((Object)t.getMessage(), t);
    }

    protected void error(MessageExchange me, Fault fault) throws MessagingException {
        me.setFault(fault);
        me.setStatus(ExchangeStatus.ERROR);
        this.context.getDeliveryChannel().send(me);
    }

    protected void done(MessageExchange me) throws MessagingException {
        me.setStatus(ExchangeStatus.DONE);
        this.context.getDeliveryChannel().send(me);
    }

    protected void error(MessageExchange me, Exception e) throws MessagingException {
        me.setError(e);
        me.setStatus(ExchangeStatus.ERROR);
        this.context.getDeliveryChannel().send(me);
    }

    private class DefaultServiceUnitManager
    implements ServiceUnitManager {
        private DefaultServiceUnitManager() {
        }

        public String deploy(String string, String string1) throws DeploymentException {
            return null;
        }

        public void init(String string, String string1) throws DeploymentException {
        }

        public void start(String string) throws DeploymentException {
        }

        public void stop(String string) throws DeploymentException {
        }

        public void shutDown(String string) throws DeploymentException {
        }

        public String undeploy(String string, String string1) throws DeploymentException {
            return null;
        }
    }

    protected class MessageExchangeWorker
    implements Work {
        private MessageExchange me;
        private MessageExchangeListener listener;

        public MessageExchangeWorker(MessageExchange me, MessageExchangeListener listener) {
            this.me = me;
            this.listener = listener;
        }

        public void release() {
        }

        public void run() {
            try {
                try {
                    this.listener.onExchange(this.me);
                    AbstractJbiComponent.this.done(this.me);
                }
                catch (MessagingException e) {
                    AbstractJbiComponent.this.error(this.me, (Exception)((Object)e));
                }
            }
            catch (Exception e) {
                AbstractJbiComponent.this.handleException(e);
            }
        }
    }
}

