/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jbi.components;

import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import org.mule.impl.MuleEvent;
import org.mule.impl.MuleSession;
import org.mule.providers.AbstractConnector;
import org.mule.providers.jbi.JbiUtils;
import org.mule.providers.jbi.components.AbstractEndpointComponent;
import org.mule.providers.jbi.components.MessageExchangeListener;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOSession;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.provider.UMOMessageDispatcher;

public class MuleDispatcher
extends AbstractEndpointComponent
implements MessageExchangeListener {
    public void onExchange(MessageExchange messageExchange) throws MessagingException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"In Mule Dispatcher");
        }
        try {
            UMOMessageDispatcher dispatcher = this.muleEndpoint.getConnector().getDispatcher((UMOImmutableEndpoint)this.muleEndpoint);
            NormalizedMessage out = messageExchange.getMessage("in");
            UMOMessage message = JbiUtils.createMessage(out);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Dispatching Message via Mule: " + message));
            }
            MuleSession session = new MuleSession(message, ((AbstractConnector)this.muleEndpoint.getConnector()).getSessionHandler());
            MuleEvent event = new MuleEvent(message, (UMOImmutableEndpoint)this.muleEndpoint, (UMOSession)session, this.muleEndpoint.isSynchronous());
            if (this.muleEndpoint.isSynchronous()) {
                this.logger.debug((Object)("Dispatching to: " + this.muleEndpoint.getEndpointURI()));
                this.logger.debug((Object)("Payload is: " + event.getMessageAsString()));
                UMOMessage result = dispatcher.send((UMOEvent)event);
            } else {
                dispatcher.dispatch((UMOEvent)event);
            }
        }
        catch (Exception e) {
            this.handleException(e);
            this.error(messageExchange, e);
        }
    }
}

