/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.bpm.jbpm;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.mule.providers.bpm.BPMS;
import org.mule.providers.bpm.MessageService;
import org.mule.providers.bpm.jbpm.MuleMessageService;
import org.mule.util.IOUtils;
import org.mule.util.NumberUtils;

public class Jbpm
implements BPMS {
    protected static final Log logger = LogFactory.getLog((Class)Jbpm.class);
    protected JbpmConfiguration jbpmConfiguration = null;
    protected boolean containerManaged;

    public Jbpm() {
        this(JbpmConfiguration.getInstance());
        this.containerManaged = false;
    }

    public Jbpm(JbpmConfiguration jbpmConfiguration) {
        this.setJbpmConfiguration(jbpmConfiguration);
        this.containerManaged = true;
    }

    public void destroy() {
        if (!this.containerManaged && this.jbpmConfiguration != null) {
            this.jbpmConfiguration.close();
            this.jbpmConfiguration = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessageService(MessageService msgService) {
        JbpmContext jbpmContext = this.jbpmConfiguration.createJbpmContext();
        try {
            MuleMessageService.setMessageService(msgService);
        }
        finally {
            jbpmContext.close();
        }
    }

    public synchronized Object startProcess(Object processType) throws Exception {
        return this.startProcess(processType, null, null);
    }

    public synchronized Object startProcess(Object processType, Object transition, Map processVariables) throws Exception {
        JbpmContext jbpmContext = this.jbpmConfiguration.createJbpmContext();
        try {
            ProcessDefinition processDefinition = jbpmContext.getGraphSession().findLatestProcessDefinition((String)processType);
            if (processDefinition == null) {
                throw new IllegalArgumentException("No process definition found for process " + processType);
            }
            ProcessInstance processInstance = new ProcessInstance(processDefinition);
            if (processVariables != null && !processVariables.isEmpty()) {
                processInstance.getContextInstance().addVariables(processVariables);
            }
            processInstance.getContextInstance().addVariables(processVariables);
            processInstance.signal();
            jbpmContext.save(processInstance);
            ProcessInstance processInstance2 = processInstance;
            return processInstance2;
        }
        catch (Exception e) {
            jbpmContext.setRollbackOnly();
            throw e;
        }
        finally {
            jbpmContext.close();
        }
    }

    public synchronized Object advanceProcess(Object processId) throws Exception {
        return this.advanceProcess(processId, null, null);
    }

    public synchronized Object advanceProcess(Object processId, Object transition, Map processVariables) throws Exception {
        JbpmContext jbpmContext = this.jbpmConfiguration.createJbpmContext();
        try {
            ProcessInstance processInstance = jbpmContext.getGraphSession().loadProcessInstance(NumberUtils.toLong((Object)processId));
            if (processInstance.hasEnded()) {
                throw new IllegalStateException("Process cannot be advanced because it has already terminated, processId = " + processId);
            }
            if (processVariables != null && !processVariables.isEmpty()) {
                processInstance.getContextInstance().addVariables(processVariables);
            }
            if (transition != null) {
                processInstance.signal((String)transition);
            } else {
                processInstance.signal();
            }
            jbpmContext.save(processInstance);
            ProcessInstance processInstance2 = processInstance;
            return processInstance2;
        }
        catch (Exception e) {
            jbpmContext.setRollbackOnly();
            throw e;
        }
        finally {
            jbpmContext.close();
        }
    }

    public synchronized Object updateProcess(Object processId, Map processVariables) throws Exception {
        JbpmContext jbpmContext = this.jbpmConfiguration.createJbpmContext();
        try {
            ProcessInstance processInstance = jbpmContext.getGraphSession().loadProcessInstance(NumberUtils.toLong((Object)processId));
            if (processVariables != null && !processVariables.isEmpty()) {
                processInstance.getContextInstance().addVariables(processVariables);
            }
            jbpmContext.save(processInstance);
            ProcessInstance processInstance2 = processInstance;
            return processInstance2;
        }
        catch (Exception e) {
            jbpmContext.setRollbackOnly();
            throw e;
        }
        finally {
            jbpmContext.close();
        }
    }

    public synchronized void abortProcess(Object processId) throws Exception {
        JbpmContext jbpmContext = this.jbpmConfiguration.createJbpmContext();
        try {
            jbpmContext.getGraphSession().deleteProcessInstance(NumberUtils.toLong((Object)processId));
        }
        catch (Exception e) {
            jbpmContext.setRollbackOnly();
            throw e;
        }
        finally {
            jbpmContext.close();
        }
    }

    public boolean isProcess(Object obj) throws Exception {
        return obj instanceof ProcessInstance;
    }

    public Object getId(Object process) throws Exception {
        return new Long(((ProcessInstance)process).getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getState(Object process) throws Exception {
        ProcessInstance processInstance = (ProcessInstance)process;
        JbpmContext jbpmContext = this.jbpmConfiguration.createJbpmContext();
        try {
            processInstance = jbpmContext.getGraphSession().loadProcessInstance(processInstance.getId());
            String string = processInstance.getRootToken().getNode().getName();
            return string;
        }
        finally {
            jbpmContext.close();
        }
    }

    public boolean hasEnded(Object process) throws Exception {
        return ((ProcessInstance)process).hasEnded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object lookupProcess(Object processId) throws Exception {
        JbpmContext jbpmContext = this.jbpmConfiguration.createJbpmContext();
        try {
            ProcessInstance processInstance;
            ProcessInstance processInstance2 = processInstance = jbpmContext.getGraphSession().loadProcessInstance(NumberUtils.toLong((Object)processId));
            return processInstance2;
        }
        finally {
            jbpmContext.close();
        }
    }

    public void deployProcess(String processDefinitionFile) throws IOException {
        this.deployProcessFromStream(IOUtils.getResourceAsStream((String)processDefinitionFile, this.getClass()));
    }

    public void deployProcessFromStream(InputStream processDefinition) throws IOException {
        this.deployProcess(ProcessDefinition.parseXmlInputStream((InputStream)processDefinition));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deployProcess(ProcessDefinition processDefinition) {
        JbpmContext jbpmContext = this.jbpmConfiguration.createJbpmContext();
        try {
            jbpmContext.deployProcessDefinition(processDefinition);
        }
        finally {
            jbpmContext.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List loadTasks(ProcessInstance process) {
        JbpmContext jbpmContext = this.jbpmConfiguration.createJbpmContext();
        try {
            List taskInstances;
            List list = taskInstances = jbpmContext.getTaskMgmtSession().findTaskInstancesByToken(process.getRootToken().getId());
            return list;
        }
        finally {
            jbpmContext.close();
        }
    }

    public synchronized void completeTask(TaskInstance task) {
        this.completeTask(task, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void completeTask(TaskInstance task, String transition) {
        JbpmContext jbpmContext = this.jbpmConfiguration.createJbpmContext();
        try {
            task = jbpmContext.getTaskMgmtSession().loadTaskInstance(task.getId());
            if (transition != null) {
                task.end(transition);
            } else {
                task.end();
            }
        }
        finally {
            jbpmContext.close();
        }
    }

    public JbpmConfiguration getJbpmConfiguration() {
        return this.jbpmConfiguration;
    }

    public void setJbpmConfiguration(JbpmConfiguration jbpmConfiguration) {
        this.jbpmConfiguration = jbpmConfiguration;
    }
}

