/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.bpm.jbpm.actions;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.jxpath.JXPathContext;
import org.jbpm.graph.exe.ExecutionContext;
import org.mule.api.MuleMessage;
import org.mule.transport.bpm.jbpm.MuleMessageService;
import org.mule.transport.bpm.jbpm.actions.LoggingActionHandler;
import org.mule.util.StringUtils;

public class SendMuleEvent
extends LoggingActionHandler {
    private static final long serialVersionUID = 1L;
    boolean synchronous = true;
    String endpoint = null;
    String transformers = null;
    Map properties = null;
    String payload = null;
    String payloadSource = null;
    private Object payloadObject;

    public void execute(ExecutionContext executionContext) throws Exception {
        super.execute(executionContext);
        MuleMessageService mule = (MuleMessageService)executionContext.getJbpmContext().getServices().getMessageService();
        if (this.transformers != null) {
            this.endpoint = this.endpoint + "?transformers=" + this.transformers;
        }
        if (this.payload == null) {
            if (this.payloadSource == null) {
                this.payloadObject = executionContext.getVariable("data");
                if (this.payloadObject == null) {
                    this.payloadObject = executionContext.getVariable("incoming");
                }
            } else {
                String[] tokens = StringUtils.split((String)this.payloadSource, (String)".", (int)2);
                this.payloadObject = executionContext.getVariable(tokens[0]);
                if (tokens.length > 1) {
                    JXPathContext context = JXPathContext.newContext((Object)this.payloadObject);
                    this.payloadObject = context.getValue(tokens[1].replaceAll("\\.", "/"));
                }
            }
        } else {
            this.payloadObject = this.payload;
        }
        if (this.payloadObject == null) {
            throw new IllegalArgumentException("Payload for message is null.  Payload source is \"" + this.payloadSource + "\"");
        }
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("MULE_BPM_PROCESS_TYPE", executionContext.getProcessDefinition().getName());
        props.put("MULE_BPM_PROCESS_ID", new Long(executionContext.getProcessInstance().getId()));
        props.put("MULE_CORRELATION_ID", new Long(executionContext.getProcessInstance().getId()).toString());
        props.put("MULE_BPM_STARTED", executionContext.getProcessInstance().getStart());
        if (this.properties != null) {
            props.putAll(this.properties);
        }
        MuleMessage response = mule.generateMessage(this.endpoint, this.payloadObject, props, this.synchronous);
        if (this.synchronous) {
            if (response != null) {
                executionContext.setVariable("incoming", response.getPayload());
            } else {
                this.logger.info((Object)("Synchronous message was sent to endpoint " + this.endpoint + ", but no response was returned."));
            }
        }
    }
}

