/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.PropertyUtils;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.DOMReader;
import org.mule.umo.endpoint.UMOImmutableEndpoint;

public abstract class JdbcUtils {
    public static void close(Connection con) throws SQLException {
        if (con != null && !con.isClosed()) {
            con.close();
        }
    }

    public static void commitAndClose(Connection con) throws SQLException {
        if (con != null) {
            if (!con.getAutoCommit()) {
                con.commit();
            }
            con.close();
        }
    }

    public static void rollbackAndClose(Connection con) throws SQLException {
        if (con != null) {
            if (!con.getAutoCommit()) {
                con.rollback();
            }
            con.close();
        }
    }

    public static String parseStatement(String stmt, List params) {
        if (stmt == null) {
            return stmt;
        }
        Pattern p = Pattern.compile("\\$\\{[^\\}]*\\}");
        Matcher m = p.matcher(stmt);
        StringBuffer sb = new StringBuffer(200);
        while (m.find()) {
            String key = m.group();
            m.appendReplacement(sb, "?");
            params.add(key);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static Object[] getParams(UMOImmutableEndpoint endpoint, List paramNames, Object root) throws Exception {
        Object[] params = new Object[paramNames.size()];
        for (int i = 0; i < paramNames.size(); ++i) {
            Node node;
            String param = (String)paramNames.get(i);
            String name = param.substring(2, param.length() - 1);
            Object value = null;
            boolean foundValue = false;
            if ("NOW".equalsIgnoreCase(name)) {
                value = new Timestamp(Calendar.getInstance().getTimeInMillis());
                foundValue = true;
            } else if (root instanceof org.w3c.dom.Document) {
                org.w3c.dom.Document x3cDoc = (org.w3c.dom.Document)root;
                Document dom4jDoc = new DOMReader().read(x3cDoc);
                try {
                    Node node2 = dom4jDoc.selectSingleNode(name);
                    if (node2 != null) {
                        value = node2.getText();
                        foundValue = true;
                    }
                }
                catch (Exception ignored) {}
            } else if (root instanceof Document) {
                Document dom4jDoc = (Document)root;
                try {
                    node = dom4jDoc.selectSingleNode(name);
                    if (node != null) {
                        value = node.getText();
                        foundValue = true;
                    }
                }
                catch (Exception ignored) {}
            } else if (root instanceof Node) {
                Node dom4jNode = (Node)root;
                try {
                    node = dom4jNode.selectSingleNode(name);
                    if (node != null) {
                        value = node.getText();
                        foundValue = true;
                    }
                }
                catch (Exception ignored) {}
            } else {
                try {
                    value = PropertyUtils.getProperty((Object)root, (String)name);
                    foundValue = value != null;
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
            if (value == null) {
                value = endpoint.getProperty((Object)name);
                boolean bl = foundValue = foundValue || endpoint.getProperties().containsKey(name);
            }
            if (name.equals("payload")) {
                value = root;
                foundValue = true;
            }
            if (value == null && !foundValue) {
                throw new IllegalArgumentException("Can not retrieve argument " + name);
            }
            params[i] = value;
        }
        return params;
    }
}

