/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jdbc.xa;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import javax.sql.XAConnection;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;

public class ConnectionWrapper
implements Connection {
    private XAConnection xaCon;
    private Connection con;
    private TransactionManager tm;
    private Transaction tx;

    public ConnectionWrapper(XAConnection xaCon, TransactionManager tm) throws SQLException {
        this.xaCon = xaCon;
        this.con = xaCon.getConnection();
        this.tm = tm;
        this.tx = null;
    }

    public int getHoldability() throws SQLException {
        return this.con.getHoldability();
    }

    public int getTransactionIsolation() throws SQLException {
        return this.con.getTransactionIsolation();
    }

    public void clearWarnings() throws SQLException {
        this.con.clearWarnings();
    }

    public void close() throws SQLException {
        this.con.close();
    }

    public void commit() throws SQLException {
        this.con.commit();
    }

    public void rollback() throws SQLException {
        this.con.rollback();
    }

    public boolean getAutoCommit() throws SQLException {
        return this.con.getAutoCommit();
    }

    public boolean isClosed() throws SQLException {
        return this.con.isClosed();
    }

    public boolean isReadOnly() throws SQLException {
        return this.con.isReadOnly();
    }

    public void setHoldability(int holdability) throws SQLException {
        this.con.setHoldability(holdability);
    }

    public void setTransactionIsolation(int level) throws SQLException {
        this.con.setTransactionIsolation(level);
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.con.setAutoCommit(autoCommit);
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this.con.setReadOnly(readOnly);
    }

    public String getCatalog() throws SQLException {
        return this.con.getCatalog();
    }

    public void setCatalog(String catalog) throws SQLException {
        this.con.setCatalog(catalog);
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return this.con.getMetaData();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.con.getWarnings();
    }

    public Savepoint setSavepoint() throws SQLException {
        return this.con.setSavepoint();
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.con.releaseSavepoint(savepoint);
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        this.con.rollback();
    }

    public Statement createStatement() throws SQLException {
        Statement st = this.con.createStatement();
        return (Statement)Proxy.newProxyInstance(Statement.class.getClassLoader(), new Class[]{Statement.class}, (InvocationHandler)new StatementInvocationHandler(st));
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        Statement st = this.con.createStatement(resultSetType, resultSetConcurrency);
        return (Statement)Proxy.newProxyInstance(Statement.class.getClassLoader(), new Class[]{Statement.class}, (InvocationHandler)new StatementInvocationHandler(st));
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        Statement st = this.con.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        return (Statement)Proxy.newProxyInstance(Statement.class.getClassLoader(), new Class[]{Statement.class}, (InvocationHandler)new StatementInvocationHandler(st));
    }

    public Map getTypeMap() throws SQLException {
        return this.con.getTypeMap();
    }

    public void setTypeMap(Map map) throws SQLException {
        this.con.setTypeMap(map);
    }

    public String nativeSQL(String sql) throws SQLException {
        return this.con.nativeSQL(sql);
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        CallableStatement cs = this.con.prepareCall(sql);
        return (CallableStatement)Proxy.newProxyInstance(CallableStatement.class.getClassLoader(), new Class[]{CallableStatement.class}, (InvocationHandler)new StatementInvocationHandler(cs));
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        CallableStatement cs = this.con.prepareCall(sql, resultSetType, resultSetConcurrency);
        return (CallableStatement)Proxy.newProxyInstance(CallableStatement.class.getClassLoader(), new Class[]{CallableStatement.class}, (InvocationHandler)new StatementInvocationHandler(cs));
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        CallableStatement cs = this.con.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        return (CallableStatement)Proxy.newProxyInstance(CallableStatement.class.getClassLoader(), new Class[]{CallableStatement.class}, (InvocationHandler)new StatementInvocationHandler(cs));
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        PreparedStatement ps = this.con.prepareStatement(sql);
        return (PreparedStatement)Proxy.newProxyInstance(PreparedStatement.class.getClassLoader(), new Class[]{PreparedStatement.class}, (InvocationHandler)new StatementInvocationHandler(ps));
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        PreparedStatement ps = this.con.prepareStatement(sql, autoGeneratedKeys);
        return (PreparedStatement)Proxy.newProxyInstance(PreparedStatement.class.getClassLoader(), new Class[]{PreparedStatement.class}, (InvocationHandler)new StatementInvocationHandler(ps));
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        PreparedStatement ps = this.con.prepareStatement(sql, resultSetType, resultSetConcurrency);
        return (PreparedStatement)Proxy.newProxyInstance(PreparedStatement.class.getClassLoader(), new Class[]{PreparedStatement.class}, (InvocationHandler)new StatementInvocationHandler(ps));
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        PreparedStatement ps = this.con.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        return (PreparedStatement)Proxy.newProxyInstance(PreparedStatement.class.getClassLoader(), new Class[]{PreparedStatement.class}, (InvocationHandler)new StatementInvocationHandler(ps));
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        PreparedStatement ps = this.con.prepareStatement(sql, columnIndexes);
        return (PreparedStatement)Proxy.newProxyInstance(PreparedStatement.class.getClassLoader(), new Class[]{PreparedStatement.class}, (InvocationHandler)new StatementInvocationHandler(ps));
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        return this.con.setSavepoint(name);
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        PreparedStatement ps = this.con.prepareStatement(sql, columnNames);
        return (PreparedStatement)Proxy.newProxyInstance(PreparedStatement.class.getClassLoader(), new Class[]{PreparedStatement.class}, (InvocationHandler)new StatementInvocationHandler(ps));
    }

    protected void enlist() throws Exception {
        if (this.tm != null && this.tx == null) {
            this.tx = this.tm.getTransaction();
            if (this.tx != null) {
                this.tx.enlistResource(this.xaCon.getXAResource());
            }
        }
    }

    protected class StatementInvocationHandler
    implements InvocationHandler {
        private Statement statement;

        public StatementInvocationHandler(Statement statement) {
            this.statement = statement;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().startsWith("execute")) {
                ConnectionWrapper.this.enlist();
            }
            try {
                return method.invoke((Object)this.statement, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

