/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.mule.MuleManager;
import org.mule.impl.MuleMessage;
import org.mule.providers.ConnectException;
import org.mule.providers.TransactedPollingMessageReceiver;
import org.mule.providers.jdbc.JdbcConnector;
import org.mule.providers.jdbc.JdbcUtils;
import org.mule.transaction.TransactionCoordination;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOTransaction;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageAdapter;

public class JdbcMessageReceiver
extends TransactedPollingMessageReceiver {
    protected JdbcConnector connector;
    protected String readStmt;
    protected String ackStmt;
    protected List readParams;
    protected List ackParams;

    public JdbcMessageReceiver(UMOConnector connector, UMOComponent component, UMOEndpoint endpoint, String readStmt, String ackStmt) throws InitialisationException {
        super(connector, component, endpoint, ((JdbcConnector)connector).getPollingFrequency());
        this.receiveMessagesInTransaction = false;
        this.connector = (JdbcConnector)connector;
        this.readParams = new ArrayList();
        this.readStmt = this.connector.parseStatement(readStmt, this.readParams);
        this.ackParams = new ArrayList();
        this.ackStmt = this.connector.parseStatement(ackStmt, this.ackParams);
    }

    protected void doDispose() {
    }

    protected void doConnect() throws Exception {
        Connection con = null;
        try {
            con = this.connector.getConnection();
        }
        catch (Exception e) {
            throw new ConnectException((Throwable)e, (Object)this);
        }
        finally {
            JdbcUtils.close(con);
        }
    }

    protected void doDisconnect() throws ConnectException {
    }

    public void processMessage(Object message) throws Exception {
        Connection con = null;
        UMOTransaction tx = TransactionCoordination.getInstance().getTransaction();
        try {
            con = this.connector.getConnection();
            UMOMessageAdapter msgAdapter = this.connector.getMessageAdapter(message);
            MuleMessage umoMessage = new MuleMessage((Object)msgAdapter);
            if (this.ackStmt != null) {
                Object[] ackParams = this.connector.getParams((UMOImmutableEndpoint)this.endpoint, this.ackParams, umoMessage);
                int nbRows = this.connector.createQueryRunner().update(con, this.ackStmt, ackParams);
                if (nbRows != 1) {
                    this.logger.warn((Object)("Row count for ack should be 1 and not " + nbRows));
                }
            }
            this.routeMessage((UMOMessage)umoMessage, tx, tx != null || this.endpoint.isSynchronous());
        }
        catch (Exception ex) {
            if (tx != null) {
                tx.setRollbackOnly();
            }
            throw ex;
        }
        finally {
            if (MuleManager.getInstance().getTransactionManager() != null || tx == null) {
                JdbcUtils.close(con);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getMessages() throws Exception {
        List list;
        Connection con = null;
        try {
            try {
                con = this.connector.getConnection();
            }
            catch (SQLException e) {
                throw new ConnectException((Throwable)e, (Object)this);
            }
            Object[] readParams = this.connector.getParams((UMOImmutableEndpoint)this.endpoint, this.readParams, null);
            Object results = this.connector.createQueryRunner().query(con, this.readStmt, readParams, this.connector.createResultSetHandler());
            list = (List)results;
        }
        catch (Throwable throwable) {
            JdbcUtils.close(con);
            throw throwable;
        }
        JdbcUtils.close(con);
        return list;
    }
}

