/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.mule.config.i18n.Message;
import org.mule.transaction.AbstractSingleResourceTransaction;
import org.mule.transaction.IllegalTransactionStateException;
import org.mule.transaction.TransactionRollbackException;
import org.mule.umo.TransactionException;

public class JdbcTransaction
extends AbstractSingleResourceTransaction {
    public void bindResource(Object key, Object resource) throws TransactionException {
        if (!(key instanceof DataSource) || !(resource instanceof Connection)) {
            throw new IllegalTransactionStateException(new Message(120, (Object)"javax.sql.DataSource/java.sql.Connection"));
        }
        Connection con = (Connection)resource;
        try {
            if (con.getAutoCommit()) {
                con.setAutoCommit(false);
            }
        }
        catch (SQLException e) {
            throw new TransactionException(new Message(119), (Throwable)e);
        }
        super.bindResource(key, resource);
    }

    protected void doBegin() throws TransactionException {
    }

    protected void doCommit() throws TransactionException {
        try {
            ((Connection)this.resource).commit();
            ((Connection)this.resource).close();
        }
        catch (SQLException e) {
            throw new TransactionException(new Message(97), (Throwable)e);
        }
    }

    protected void doRollback() throws TransactionException {
        try {
            ((Connection)this.resource).rollback();
            ((Connection)this.resource).close();
        }
        catch (SQLException e) {
            throw new TransactionRollbackException(new Message(98), (Throwable)e);
        }
    }
}

