/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jdbc.xa;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import javax.transaction.TransactionManager;
import org.mule.providers.jdbc.xa.ConnectionWrapper;

public class DataSourceWrapper
implements DataSource {
    private XADataSource xads;
    private TransactionManager tm;

    public DataSourceWrapper() {
    }

    public DataSourceWrapper(XADataSource xads, TransactionManager tm) {
        this.xads = xads;
        this.tm = tm;
    }

    public int getLoginTimeout() throws SQLException {
        return this.xads.getLoginTimeout();
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        this.xads.setLoginTimeout(seconds);
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.xads.getLogWriter();
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        this.xads.setLogWriter(out);
    }

    public Connection getConnection() throws SQLException {
        return new ConnectionWrapper(this.xads.getXAConnection(), this.tm);
    }

    public Connection getConnection(String username, String password) throws SQLException {
        return new ConnectionWrapper(this.xads.getXAConnection(username, password), this.tm);
    }

    public TransactionManager getTransactionManager() {
        return this.tm;
    }

    public void setTransactionManager(TransactionManager tm) {
        this.tm = tm;
    }

    public XADataSource getXaDataSource() {
        return this.xads;
    }

    public void setXaDataSource(XADataSource xads) {
        this.xads = xads;
    }
}

