/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jdbc;

import com.mockobjects.dynamic.Mock;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import junit.framework.Assert;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.mule.impl.ImmutableMuleEndpoint;
import org.mule.providers.jdbc.JdbcConnector;
import org.mule.tck.AbstractMuleTestCase;

public class JdbcMessageDispatcherTestCase
extends AbstractMuleTestCase {
    public void testCustomResultSetHandlerIsNotIgnored() throws Exception {
        ImmutableMuleEndpoint ep = new ImmutableMuleEndpoint("jdbc://select * from test", false);
        JdbcConnector connector = (JdbcConnector)ep.getConnector();
        connector.setQueryRunner(TestQueryRunner.class.getName());
        connector.setResultSetHandler(TestResultSetHandler.class.getName());
        connector.setDataSource(this.getDataSource());
        connector.initialise();
        ep.receive(0L);
    }

    protected DataSource getDataSource() {
        Mock mockDataSource = new Mock(DataSource.class);
        Mock mockConnection = new Mock(Connection.class);
        mockDataSource.expectAndReturn("getConnection", mockConnection.proxy());
        mockConnection.expectAndReturn("getAutoCommit", false);
        mockConnection.expect("commit");
        mockConnection.expect("close");
        return (DataSource)mockDataSource.proxy();
    }

    public static final class TestResultSetHandler
    implements ResultSetHandler {
        public Object handle(ResultSet resultSet) throws SQLException {
            return new Object();
        }
    }

    public static final class TestQueryRunner
    extends QueryRunner {
        public Object query(Connection connection, String string, Object[] objects, ResultSetHandler resultSetHandler) throws SQLException {
            Assert.assertTrue((String)"Custom result set handler has been ignored.", (boolean)(resultSetHandler instanceof TestResultSetHandler));
            return new Object();
        }
    }
}

