/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jdbc;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.dbutils.QueryRunner;
import org.mule.MuleManager;
import org.mule.extras.client.MuleClient;
import org.mule.impl.MuleMessage;
import org.mule.providers.NullPayload;
import org.mule.providers.jdbc.JdbcConnector;
import org.mule.providers.jdbc.util.MuleDerbyUtils;
import org.mule.tck.FunctionalTestCase;
import org.mule.umo.UMOMessage;

public class JdbcSelectOnOutboundFunctionalTestCase
extends FunctionalTestCase {
    private static final String[] TEST_VALUES = new String[]{"Test", "The Moon", "Terra"};

    protected String getConfigResources() {
        return "jdbc-select-outbound.xml";
    }

    protected void doPostFunctionalSetUp() throws Exception {
        int updated;
        super.doPostFunctionalSetUp();
        JdbcConnector jdbcConnector = (JdbcConnector)MuleManager.getInstance().getConnectors().get("jdbcConnector");
        QueryRunner qr = new QueryRunner(jdbcConnector.getDataSource());
        qr.update(jdbcConnector.getConnection(), "CREATE PROCEDURE TEST_PROC(IN A INTEGER,\nINOUT B INTEGER, OUT C DOUBLE, OUT S VARCHAR(1024))\nPARAMETER STYLE JAVA READS SQL DATA LANGUAGE JAVA EXTERNAL NAME \n'org.mule.providers.jdbc.DerbyStoredProc.plus'");
        this.logger.debug((Object)"Procedure created");
        try {
            updated = qr.update(jdbcConnector.getConnection(), "DELETE FROM TEST");
            this.logger.debug((Object)(updated + " rows deleted"));
        }
        catch (Exception e) {
            qr.update(jdbcConnector.getConnection(), "CREATE TABLE TEST(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0)  NOT NULL PRIMARY KEY,TYPE INTEGER,DATA VARCHAR(255),ACK TIMESTAMP,RESULT VARCHAR(255))");
            this.logger.debug((Object)"Table created");
        }
        updated = qr.update(jdbcConnector.getConnection(), "INSERT INTO TEST(TYPE, DATA) VALUES (1, '" + TEST_VALUES[0] + "')");
        this.logger.debug((Object)(updated + " rows updated"));
        updated = qr.update(jdbcConnector.getConnection(), "INSERT INTO TEST(TYPE, DATA) VALUES (2, '" + TEST_VALUES[1] + "')");
        this.logger.debug((Object)(updated + " rows updated"));
        updated = qr.update(jdbcConnector.getConnection(), "INSERT INTO TEST(TYPE, DATA) VALUES (3, '" + TEST_VALUES[2] + "')");
        this.logger.debug((Object)(updated + " rows updated"));
    }

    protected void doFunctionalTearDown() throws Exception {
        JdbcConnector jdbcConnector = (JdbcConnector)MuleManager.getInstance().getConnectors().get("jdbcConnector");
        QueryRunner qr = new QueryRunner(jdbcConnector.getDataSource());
        int updated = qr.update(jdbcConnector.getConnection(), "DELETE FROM TEST");
        this.logger.debug((Object)(updated + " rows deleted"));
        qr.update(jdbcConnector.getConnection(), "DROP PROCEDURE TEST_PROC");
        this.logger.debug((Object)"Procedure dropped");
        super.doFunctionalTearDown();
    }

    protected void suitePreSetUp() throws Exception {
        MuleDerbyUtils.defaultDerbyCleanAndInit((String)"derby.properties", (String)"database.name");
        super.suitePreSetUp();
    }

    public void testSelectOnOutbound() throws Exception {
        MuleClient client = new MuleClient();
        UMOMessage reply = client.send("vm://jdbc.test", (UMOMessage)new MuleMessage((Object)NullPayload.getInstance()));
        JdbcSelectOnOutboundFunctionalTestCase.assertNotNull((Object)reply.getPayload());
        JdbcSelectOnOutboundFunctionalTestCase.assertTrue((boolean)(reply.getPayload() instanceof List));
        List resultList = (List)reply.getPayload();
        JdbcSelectOnOutboundFunctionalTestCase.assertTrue((resultList.size() == 1 ? 1 : 0) != 0);
        JdbcSelectOnOutboundFunctionalTestCase.assertTrue((boolean)(resultList.get(0) instanceof Map));
        Map resultMap = (Map)resultList.get(0);
        JdbcSelectOnOutboundFunctionalTestCase.assertEquals((Object)new Integer(1), resultMap.get("TYPE"));
        JdbcSelectOnOutboundFunctionalTestCase.assertEquals((Object)TEST_VALUES[0], resultMap.get("DATA"));
    }

    private void internalStoredProcTest(String endpoint, UMOMessage message) throws Exception {
        MuleClient client = new MuleClient();
        UMOMessage reply = client.send(endpoint, message);
        JdbcSelectOnOutboundFunctionalTestCase.assertNotNull((Object)reply.getPayload());
        JdbcSelectOnOutboundFunctionalTestCase.assertTrue((boolean)(reply.getPayload() instanceof Map));
        Map resultMap = (Map)reply.getPayload();
        JdbcSelectOnOutboundFunctionalTestCase.assertTrue((resultMap.size() == 3 ? 1 : 0) != 0);
        JdbcSelectOnOutboundFunctionalTestCase.assertEquals(resultMap.get("b"), (Object)new Integer(10));
        JdbcSelectOnOutboundFunctionalTestCase.assertEquals(resultMap.get("c"), (Object)new Double(8.3));
        JdbcSelectOnOutboundFunctionalTestCase.assertEquals(resultMap.get("s"), (Object)"test");
    }

    public void testStoredProc() throws Exception {
        this.internalStoredProcTest("vm://proc.test", (UMOMessage)new MuleMessage((Object)NullPayload.getInstance()));
    }

    public void testEndpointProperties() throws Exception {
        this.internalStoredProcTest("vm://proc2.test", (UMOMessage)new MuleMessage((Object)NullPayload.getInstance()));
    }

    public void testCallProcByMapPropertyExtractor() throws Exception {
        this.internalStoredProcTest("vm://proc3.test", new MapMessageFactory().createMessage());
    }

    public void testCallProcByPayloadPropertyExtractor() throws Exception {
        this.internalStoredProcTest("vm://proc3.test", new PayloadMessageFactory().createMessage());
    }

    public void testCallProcByMessagePropertyExtractor() throws Exception {
        this.internalStoredProcTest("vm://proc4.test", new PropertiesMessageFactory().createMessage());
    }

    public void testInsert() throws Exception {
        MuleClient client = new MuleClient();
        UMOMessage reply = client.send("vm://insert.test", (UMOMessage)new MuleMessage((Object)NullPayload.getInstance()));
        JdbcSelectOnOutboundFunctionalTestCase.assertTrue((boolean)(reply.getPayload() instanceof NullPayload));
        JdbcConnector jdbcConnector = (JdbcConnector)MuleManager.getInstance().getConnectors().get("jdbcConnector");
        PreparedStatement statement = jdbcConnector.getConnection().prepareStatement("SELECT type, data FROM Test WHERE type = 4 AND data='test insert'");
        ResultSet result = statement.executeQuery();
        int counter = 0;
        while (result.next()) {
            ++counter;
        }
        JdbcSelectOnOutboundFunctionalTestCase.assertEquals((int)counter, (int)1);
        result.close();
        statement.close();
    }

    public void testSelectOnOutboundByPropertyExtractor() throws Exception {
        MuleClient client = new MuleClient();
        MyMessage payload = new MyMessage(2);
        UMOMessage reply = client.send("vm://terra", (UMOMessage)new MuleMessage((Object)payload));
        JdbcSelectOnOutboundFunctionalTestCase.assertNotNull((Object)reply.getPayload());
        JdbcSelectOnOutboundFunctionalTestCase.assertTrue((boolean)(reply.getPayload() instanceof List));
        List resultList = (List)reply.getPayload();
        this.logger.debug((Object)("resultList.size() " + resultList.size()));
        JdbcSelectOnOutboundFunctionalTestCase.assertTrue((resultList.size() == 1 ? 1 : 0) != 0);
        JdbcSelectOnOutboundFunctionalTestCase.assertTrue((boolean)(resultList.get(0) instanceof Map));
        Map resultMap = (Map)resultList.get(0);
        JdbcSelectOnOutboundFunctionalTestCase.assertEquals((Object)new Integer(2), resultMap.get("TYPE"));
        JdbcSelectOnOutboundFunctionalTestCase.assertEquals((Object)TEST_VALUES[1], resultMap.get("DATA"));
    }

    class PropertiesMessageFactory
    implements MessageFactory {
        PropertiesMessageFactory() {
        }

        public UMOMessage createMessage() {
            MuleMessage message = new MuleMessage((Object)NullPayload.getInstance());
            message.setIntProperty("a", 3);
            message.setIntProperty("b", 5);
            return message;
        }
    }

    class PayloadMessageFactory
    implements MessageFactory {
        PayloadMessageFactory() {
        }

        public UMOMessage createMessage() {
            AnotherMessage payload = new AnotherMessage(3, 5);
            return new MuleMessage((Object)payload);
        }
    }

    class MapMessageFactory
    implements MessageFactory {
        MapMessageFactory() {
        }

        public UMOMessage createMessage() {
            HashMap<String, Integer> payload = new HashMap<String, Integer>();
            payload.put("a", new Integer(3));
            payload.put("b", new Integer(5));
            return new MuleMessage(payload);
        }
    }

    static interface MessageFactory {
        public UMOMessage createMessage();
    }

    public static class AnotherMessage
    implements Serializable {
        private int a;
        private int b;

        public AnotherMessage(int a, int b) {
            this.a = a;
            this.b = b;
        }

        public int getA() {
            return this.a;
        }

        public void setA(int a) {
            this.a = a;
        }

        public int getB() {
            return this.b;
        }

        public void setB(int b) {
            this.b = b;
        }
    }

    public static class MyMessage
    implements Serializable {
        private int type;

        public MyMessage(int type) {
            this.type = type;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int type) {
            this.type = type;
        }
    }
}

