/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jdbc;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.mule.MuleException;
import org.mule.config.ExceptionHelper;
import org.mule.config.ExceptionReader;
import org.mule.config.i18n.MessageFactory;
import org.mule.providers.jdbc.SQLExceptionReader;
import org.mule.tck.AbstractMuleTestCase;

public class SqlExceptionReaderTestCase
extends AbstractMuleTestCase {
    protected void doSetUp() throws Exception {
        ExceptionHelper.registerExceptionReader((ExceptionReader)new SQLExceptionReader());
    }

    public void testNestedExceptionRetreval() throws Exception {
        Exception testException = this.getException();
        Throwable t = ExceptionHelper.getRootException((Throwable)testException);
        SqlExceptionReaderTestCase.assertNotNull((Object)t);
        SqlExceptionReaderTestCase.assertEquals((String)"blah", (String)t.getMessage());
        SqlExceptionReaderTestCase.assertNull((Object)t.getCause());
        t = ExceptionHelper.getRootMuleException((Throwable)testException);
        SqlExceptionReaderTestCase.assertNotNull((Object)t);
        SqlExceptionReaderTestCase.assertEquals((String)"bar", (String)t.getMessage());
        SqlExceptionReaderTestCase.assertNotNull((Object)t.getCause());
        List l = ExceptionHelper.getExceptionsAsList((Throwable)testException);
        SqlExceptionReaderTestCase.assertEquals((int)4, (int)l.size());
        Map info = ExceptionHelper.getExceptionInfo((Throwable)testException);
        SqlExceptionReaderTestCase.assertNotNull((Object)info);
        SqlExceptionReaderTestCase.assertEquals((int)3, (int)info.size());
        SqlExceptionReaderTestCase.assertNotNull(info.get("JavaDoc"));
        SqlExceptionReaderTestCase.assertEquals((Object)"1234", info.get("SQL Code"));
        SqlExceptionReaderTestCase.assertEquals((Object)"bad SQL state", info.get("SQL State"));
    }

    private Exception getException() {
        SQLException e = new SQLException("SQL error", "bad SQL state", 1234);
        e.setNextException(new SQLException("blah"));
        return new MuleException(MessageFactory.createStaticMessage((String)"foo"), (Throwable)new MuleException(MessageFactory.createStaticMessage((String)"bar"), (Throwable)e));
    }
}

